/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.goclipse.core;

import com.googlecode.goclipse.core.GoEnvironmentPrefs;
import com.googlecode.goclipse.tooling.GoPackageName;
import com.googlecode.goclipse.tooling.env.GoEnvironment;
import com.googlecode.goclipse.tooling.env.GoEnvironmentConstants;
import com.googlecode.goclipse.tooling.env.GoPath;
import com.googlecode.goclipse.tooling.env.GoRoot;
import com.googlecode.goclipse.tooling.env.GoWorkspaceLocation;
import com.googlecode.goclipse.tooling.oracle.GoOperationContext;
import java.util.Collection;
import java.util.Optional;
import melnorme.lang.ide.core.LangCore;
import melnorme.lang.ide.core.utils.ResourceUtils;
import melnorme.lang.ide.core.utils.prefs.IProjectPreference;
import melnorme.lang.tooling.ast.SourceRange;
import melnorme.lang.tooling.common.ISourceBuffer;
import melnorme.lang.tooling.toolchain.ops.IToolOperationService;
import melnorme.lang.tooling.toolchain.ops.SourceOpContext;
import melnorme.utilbox.collections.ArrayList2;
import melnorme.utilbox.collections.Collection2;
import melnorme.utilbox.core.CommonException;
import melnorme.utilbox.core.CoreUtil;
import melnorme.utilbox.misc.Location;
import melnorme.utilbox.misc.StringUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;

public class GoProjectEnvironment
implements GoEnvironmentConstants {
    public static GoOperationContext getGoOperationContext(ISourceBuffer sourceBuffer, int offset) {
        SourceOpContext opContext = sourceBuffer.getSourceOpContext(new SourceRange(offset, 0));
        IProject project = ResourceUtils.getProjectFromMemberLocation(opContext.getOptionalFileLocation());
        GoEnvironment goEnv = GoProjectEnvironment.getGoEnvironment(project);
        IToolOperationService toolsOpService = LangCore.getToolManager().getEngineToolsOperationService();
        return new GoOperationContext(sourceBuffer, opContext, toolsOpService, goEnv);
    }

    public static GoRoot getEffectiveGoRoot(IProject project) {
        String prefValue = LangCore.settings().SDK_LOCATION.getRawValue(project);
        return new GoRoot(StringUtil.nullAsEmpty((String)prefValue));
    }

    public static GoPath getEffectiveGoPath(IProject project) {
        String goPathPref = GoProjectEnvironment.getEffectiveValueFromEnv(GoEnvironmentPrefs.GO_PATH, project, "GOPATH");
        GoPath rawGoPath = new GoPath(goPathPref);
        if (project == null) {
            return rawGoPath;
        }
        Location projectLoc = ResourceUtils.getResourceLocation((IResource)project);
        if (projectLoc == null) {
            return rawGoPath;
        }
        GoWorkspaceLocation goPathEntry = rawGoPath.findGoPathEntryForSourceLocation(projectLoc);
        if (goPathEntry != null) {
            return rawGoPath;
        }
        if (GoEnvironmentPrefs.APPEND_PROJECT_LOC_TO_GOPATH.getEffectiveValue(CoreUtil.option((Object)project)).booleanValue()) {
            ArrayList2 newGoPathEntries = new ArrayList2((Collection2)rawGoPath.getGoPathEntries());
            newGoPathEntries.add((Object)projectLoc.toPathString());
            return new GoPath((Collection)newGoPathEntries);
        }
        return rawGoPath;
    }

    public static boolean isProjectInsideGoPathSourceFolder(IProject project) throws CommonException {
        GoPath goPath = GoProjectEnvironment.getEffectiveGoPath(project);
        return GoProjectEnvironment.isProjectInsideGoPathSourceFolder(project, goPath);
    }

    public static boolean isProjectInsideGoPathSourceFolder(IProject project, GoPath goPath) {
        Location projectLocation;
        try {
            projectLocation = ResourceUtils.getProjectLocation2(project);
        }
        catch (CommonException e) {
            return false;
        }
        return goPath.findGoPathEntryForSourceLocation(projectLocation) != null;
    }

    protected static String getEffectiveValueFromEnv(IProjectPreference<String> pref, IProject project, String envAlternative) {
        String prefValue = pref.getEffectiveValue(Optional.ofNullable(project));
        if (prefValue == null) {
            return StringUtil.nullAsEmpty((String)System.getenv(envAlternative));
        }
        return prefValue;
    }

    public static GoEnvironment getGoEnvironmentFromLocation(Location fileLocation) {
        IProject project = ResourceUtils.getProjectFromMemberLocation(fileLocation);
        return GoProjectEnvironment.getGoEnvironment(project);
    }

    public static GoEnvironment getGoEnvironment(IProject project) {
        GoRoot goRoot = GoProjectEnvironment.getEffectiveGoRoot(project);
        GoPath goPath = GoProjectEnvironment.getEffectiveGoPath(project);
        return new GoEnvironment(goRoot, goPath);
    }

    public static GoEnvironment getValidatedGoEnvironment(IProject project) throws CommonException {
        GoEnvironment goEnv = GoProjectEnvironment.getGoEnvironment(project);
        goEnv.validate();
        return goEnv;
    }

    public static ArrayList2<GoPackageName> findSourcePackages(IProject project, GoEnvironment goEnvironment) throws CommonException {
        return goEnvironment.getGoPath().findGoSourcePackages(ResourceUtils.getProjectLocation2(project));
    }

    public static Location getBinFolderLocation(IProject project) throws CommonException {
        GoEnvironment goEnv = GoProjectEnvironment.getGoEnvironment(project);
        return goEnv.getBinFolderLocationForSubLocation(ResourceUtils.loc(project.getLocation()));
    }
}

