/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.goclipse.core;

import java.nio.file.Path;
import melnorme.lang.ide.core.utils.prefs.DerivedValuePreference;
import melnorme.lang.ide.core.utils.prefs.OptionalStringPreference;
import melnorme.lang.utils.validators.LocationOrSinglePathValidator;
import melnorme.lang.utils.validators.PathValidator;
import melnorme.utilbox.fields.validation.ValidationException;
import melnorme.utilbox.status.Severity;

public interface GoToolPreferences {
    public static final PathValidator GURU_PATH_validator = new GoToolValidator("guru path");
    public static final PathValidator GODEF_PATH_validator = new GoToolValidator("godef path");
    public static final PathValidator GOFMT_PATH_validator = new GoToolValidator("gofmt path");
    public static final DerivedValuePreference<Path> GO_GURU_Path = new DerivedValuePreference("GoToolPreferences.GO_GURU_Path", "", null, GURU_PATH_validator);
    public static final DerivedValuePreference<Path> GODEF_Path = new DerivedValuePreference("GoToolPreferences.godef.Path", "", null, GODEF_PATH_validator);
    public static final DerivedValuePreference<Path> GOFMT_Path = new DerivedValuePreference(new OptionalStringPreference("GoToolPreferences.GOFMT_Path", null), GOFMT_PATH_validator);

    public static class GoToolValidator
    extends LocationOrSinglePathValidator {
        public GoToolValidator(String fieldNamePrefix) {
            super(fieldNamePrefix);
        }

        protected String getFullMessage(String simpleMessage) {
            return super.getFullMessage(simpleMessage);
        }

        protected ValidationException createIsEmptyException() {
            String baseMsg = String.valueOf(this.fieldNamePrefix) + " is not configured.";
            String detailsMsg = "The " + this.fieldNamePrefix + " setting needs to be configured in the " + this.linkGoPreferences() + ".\n" + "See the " + this.linkUserGuide() + " for more information.";
            return new ValidationException(Severity.WARNING, baseMsg, detailsMsg);
        }

        protected String linkGoPreferences() {
            return GoToolValidator.linkReference("Go preferences", "pref:com.googlecode.goclipse.ui.PreferencePages.GocodePreferencePage");
        }

        protected String linkUserGuide() {
            return GoToolValidator.linkReference("UserGuide", "https://github.com/GoClipse/goclipse/blob/latest/documentation/UserGuide.md#user-guide");
        }

        public static String linkReference(String text, String target) {
            return "<a href=\"" + target + "\">" + text + "</a>";
        }
    }
}

