/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.core;

import melnorme.lang.ide.core.CoreSettings;
import melnorme.lang.ide.core.LangCore;
import melnorme.lang.ide.core.LangCore_Actual;
import melnorme.lang.ide.core.LoggingCore;
import melnorme.lang.ide.core.engine.SourceModelManager;
import melnorme.lang.ide.core.operations.ToolManager;
import melnorme.lang.ide.core.operations.build.BuildManager;
import melnorme.lang.ide.core.project_model.BundleModelManager;
import melnorme.lang.ide.core.project_model.LangBundleModel;
import melnorme.utilbox.misc.ILogHandler;

public abstract class AbstractLangCore
extends LoggingCore {
    public static LangCore instance;
    protected final ILogHandler logHandler;
    protected final CoreSettings coreSettings;
    protected final ToolManager toolManager;
    protected final BundleModelManager<? extends LangBundleModel> bundleManager;
    protected final BuildManager buildManager;
    protected final SourceModelManager sourceModelManager;

    public static LangCore get() {
        return instance;
    }

    public AbstractLangCore(ILogHandler logHandler) {
        instance = (LangCore)this;
        this.logHandler = logHandler;
        this.coreSettings = this.createCoreSettings();
        this.toolManager = this.createToolManager();
        this.bundleManager = LangCore_Actual.createBundleModelManager();
        this.buildManager = this.createBuildManager();
        this.sourceModelManager = LangCore_Actual.createSourceModelManager();
    }

    protected void shutdown() {
        this.buildManager.dispose();
        this.bundleManager.shutdownManager();
        this.sourceModelManager.dispose();
        this.toolManager.shutdownNow();
    }

    public static ILogHandler log() {
        return AbstractLangCore.instance.logHandler;
    }

    protected abstract CoreSettings createCoreSettings();

    public static CoreSettings settings() {
        return AbstractLangCore.instance.coreSettings;
    }

    protected abstract ToolManager createToolManager();

    public static ToolManager getToolManager() {
        return AbstractLangCore.instance.toolManager;
    }

    public static BundleModelManager<? extends LangBundleModel> getBundleModelManager() {
        return AbstractLangCore.instance.bundleManager;
    }

    public static LangBundleModel getBundleModel() {
        return AbstractLangCore.getBundleModelManager().getModel();
    }

    protected abstract BuildManager createBuildManager();

    public static BuildManager getBuildManager() {
        return AbstractLangCore.instance.buildManager;
    }

    public static SourceModelManager getSourceModelManager() {
        return AbstractLangCore.instance.sourceModelManager;
    }

    public void startAgentsAfterUIStart() {
        this.bundleManager.startManager();
    }
}

