/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.core;

import java.nio.file.Path;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import melnorme.lang.ide.core.SettingsChangeListener;
import melnorme.lang.ide.core.operations.ToolchainPreferences;
import melnorme.lang.ide.core.utils.prefs.IProjectPreference;
import melnorme.lang.ide.core.utils.prefs.PreferenceHelper;
import melnorme.lang.tooling.LocationHandle;
import melnorme.lang.utils.validators.PathValidator;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.core.CoreUtil;
import melnorme.utilbox.fields.ListenerListHelper;
import melnorme.utilbox.fields.validation.Validator;
import melnorme.utilbox.misc.Location;
import melnorme.utilbox.ownership.IDisposable;
import melnorme.utilbox.status.StatusException;
import org.eclipse.core.resources.IProject;

public abstract class CoreSettings {
    public final SettingsField<Path> SDK_LOCATION;
    protected final ListenerListHelper<SettingsChangeListener> listeners = new ListenerListHelper();

    public CoreSettings() {
        this.SDK_LOCATION = CoreSettings.newPathPreference(ToolchainPreferences.SDK_PATH, (Validator<String, Path>)this.getSDKLocationValidator());
    }

    public abstract PathValidator getSDKLocationValidator();

    public static SettingsField<Path> newPathPreference(IProjectPreference<String> pref, Validator<String, Path> validator) {
        return new SettingsField<Path>(pref, validator, path -> path.toString());
    }

    public static SettingsField<Location> newLocationPreference(IProjectPreference<String> pref, Validator<String, Location> validator) {
        return new SettingsField<Location>(pref, validator, loc -> loc.toString());
    }

    public <T> void notifySettingChanged(IProjectPreference<T> setting, LocationHandle locationHandle, T newValue) {
        Assert.AssertNamespace.assertNotNull(setting);
        for (SettingsChangeListener changeListener : this.listeners.getListeners()) {
            changeListener.preferenceChanged(setting, locationHandle, newValue);
        }
    }

    public IDisposable addSettingsListener(final SettingsChangeListener listener) {
        this.listeners.addListener((Object)listener);
        return new IDisposable(){

            public void dispose() {
                CoreSettings.this.removeSettingsListener(listener);
            }
        };
    }

    public void removeSettingsListener(SettingsChangeListener listener) {
        this.listeners.removeListener((Object)listener);
    }

    public static class SettingsField<TYPE> {
        public final IProjectPreference<String> preference;
        public final Validator<String, TYPE> validator;
        public final Validator<String, String> validator_toString;

        public SettingsField(IProjectPreference<String> preference, Validator<String, TYPE> validator, Function<TYPE, String> backToString) {
            this.preference = (IProjectPreference)Assert.AssertNamespace.assertNotNull(preference);
            this.validator = (Validator)Assert.AssertNamespace.assertNotNull(validator);
            this.validator_toString = value -> (String)backToString.apply(validator.validateField(value));
        }

        public PreferenceHelper<String> getGlobalPreference() {
            return this.preference.getGlobalPreference();
        }

        public IProjectPreference<String> getProjectPreference() {
            return this.preference;
        }

        public IProjectPreference<Boolean> getEnableProjectSettingsPref() {
            return this.getProjectPreference().getEnableProjectSettingPref();
        }

        public Validator<String, TYPE> getValidator() {
            return this.validator;
        }

        public Validator<String, String> getValidator_toString() {
            return this.validator_toString;
        }

        public TYPE getValue() throws StatusException {
            return (TYPE)this.validator.validateField((Object)((String)this.preference.getGlobalPreference().get()));
        }

        public TYPE getValue(IProject project) throws StatusException {
            return this.getValue(CoreUtil.option((Object)project));
        }

        public TYPE getValue(Optional<IProject> project) throws StatusException {
            return (TYPE)this.validator.validateField((Object)this.preference.getEffectiveValue(project));
        }

        public final String getRawValue(IProject project) {
            return this.getRawValue(CoreUtil.option((Object)project));
        }

        public String getRawValue(Optional<IProject> project) {
            return this.preference.getEffectiveValue(project);
        }

        public Supplier<String> getRawValueSupplier(Optional<IProject> project) {
            if (project.isPresent()) {
                return this.preference.getEffectiveValueProperty(project);
            }
            return this.preference.getGlobalPreference();
        }

        public void doSetRawValue(IProject project, String value) {
            this.preference.doSetValue(project, value);
        }
    }
}

