/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.core.engine;

import melnorme.lang.ide.core.engine.AbstractProjectReconcileManager;
import melnorme.lang.ide.core.operations.ILangOperationsListener_Default;
import melnorme.lang.ide.core.operations.build.BuildManager;
import melnorme.lang.tooling.common.ops.IOperationMonitor;
import melnorme.utilbox.concurrency.ICancelMonitor;
import melnorme.utilbox.concurrency.ICommonExecutor;
import melnorme.utilbox.concurrency.OperationCancellation;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.core.CommonException;
import org.eclipse.core.resources.IProject;

public class ProjectReconcileManager
extends AbstractProjectReconcileManager {
    protected final BuildManager buildMgr;
    protected boolean checkBuildOnSave = false;

    public ProjectReconcileManager(ICommonExecutor executor, BuildManager buildMgr) {
        super(executor);
        this.buildMgr = (BuildManager)Assert.AssertNamespace.assertNotNull((Object)buildMgr);
    }

    @Override
    public void doProjectReconcile(IProject project, ICancelMonitor cm) {
        boolean clearConsole = false;
        ILangOperationsListener_Default.IToolOperationMonitor opMonitor = this.buildMgr.getToolManager().startNewOperation(ILangOperationsListener_Default.ProcessStartKind.CHECK_BUILD, clearConsole, false);
        try {
            this.buildMgr.newProjectBuildOperation(opMonitor, project, true, true).execute((IOperationMonitor)new IOperationMonitor.NullOperationMonitor(cm));
        }
        catch (CommonException e) {
            opMonitor.writeInfoMessage("Error during auto-check:\n" + e.getSingleLineRender() + "\n");
        }
        catch (OperationCancellation e) {
            return;
        }
    }
}

