/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.core.launch;

import melnorme.lang.ide.core.LangCore;
import melnorme.lang.ide.core.launch.ILaunchConfigSerializer;
import melnorme.lang.ide.core.utils.ProjectValidator;
import melnorme.lang.ide.core.utils.ResourceUtils;
import melnorme.utilbox.core.CommonException;
import melnorme.utilbox.core.CoreUtil;
import melnorme.utilbox.misc.StringUtil;
import melnorme.utilbox.status.StatusException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;

public class ProjectLaunchSettings
implements ILaunchConfigSerializer {
    public ProjectValidator projectValidator = new ProjectValidator("com.googlecode.goclipse.core.goNature");
    public String projectName = "";

    public ProjectLaunchSettings() {
    }

    public ProjectLaunchSettings(String projectName) {
        this.projectName = projectName;
    }

    public ProjectLaunchSettings(ILaunchConfiguration config) throws CoreException {
        this.projectName = config.getAttribute("project", "");
    }

    public IProject getProject() {
        if (this.projectName == null || this.projectName.isEmpty()) {
            return null;
        }
        return ResourceUtils.getProject(this.projectName);
    }

    @Override
    public ProjectLaunchSettings initFrom(IResource contextualResource) {
        IProject validProject;
        if (contextualResource == null) {
            return this;
        }
        IProject project = contextualResource.getProject();
        try {
            validProject = this.projectValidator.getProject(project.getName());
        }
        catch (StatusException e) {
            return this;
        }
        try {
            this.initFromProject(validProject);
        }
        catch (CommonException e) {
            LangCore.logError("Error initializing launch settings from context resource: ", e);
        }
        return this;
    }

    public ProjectLaunchSettings initFromProject(IProject project) throws CommonException {
        this.projectName = project.getName();
        return this;
    }

    protected ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }

    public ILaunchConfiguration createNewConfiguration(ILaunchConfigurationType launchCfgType) throws CoreException, CommonException {
        String suggestedName = this.getSuggestedConfigName();
        String launchName = this.getLaunchManager().generateLaunchConfigurationName(suggestedName);
        ILaunchConfigurationWorkingCopy wc = launchCfgType.newInstance(null, launchName);
        this.saveToConfig(wc);
        return wc.doSave();
    }

    public final String getSuggestedConfigName() {
        String suggestedName = StringUtil.nullAsEmpty((String)this.getSuggestedConfigName_do()).trim();
        if (suggestedName.isEmpty()) {
            return "New Launch";
        }
        return suggestedName;
    }

    protected String getSuggestedConfigName_do() {
        return StringUtil.nullAsEmpty((String)this.projectName);
    }

    @Override
    public void saveToConfig(ILaunchConfigurationWorkingCopy config, boolean rename) throws CommonException {
        config.setAttribute("project", this.projectName);
        config.setMappedResources((IResource[])CoreUtil.array((Object[])new IProject[]{this.getProject()}));
        if (rename) {
            String suggestedName = this.getSuggestedConfigName();
            String newName = this.getLaunchManager().generateLaunchConfigurationName(suggestedName);
            config.rename(newName);
        }
        this.saveToConfig_rest(config);
    }

    protected void saveToConfig_rest(ILaunchConfigurationWorkingCopy config) throws CommonException {
    }
}

