/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.core.operations;

import java.text.MessageFormat;
import java.util.Map;
import melnorme.lang.ide.core.EclipseCore;
import melnorme.lang.ide.core.LangCore;
import melnorme.lang.ide.core.operations.ILangOperationsListener_Default;
import melnorme.lang.ide.core.operations.ToolManager;
import melnorme.lang.ide.core.operations.build.BuildManager;
import melnorme.lang.ide.core.utils.EclipseUtils;
import melnorme.lang.ide.core.utils.ResourceUtils;
import melnorme.lang.ide.core.utils.TextMessageUtils;
import melnorme.lang.tooling.common.ops.Operation;
import melnorme.utilbox.collections.HashMap2;
import melnorme.utilbox.concurrency.OperationCancellation;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.core.CommonException;
import melnorme.utilbox.misc.Location;
import org.eclipse.core.resources.IBuildConfiguration;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class LangProjectBuilder
extends IncrementalProjectBuilder {
    protected final BuildManager buildManager = LangCore.getBuildManager();
    protected static HashMap2<String, ILangOperationsListener_Default.IToolOperationMonitor> workspaceOpMonitorMap = new HashMap2();
    protected ILangOperationsListener_Default.IToolOperationMonitor workspaceOpMonitor;

    protected Location getProjectLocation() throws CommonException {
        return ResourceUtils.getProjectLocation2(this.getProject());
    }

    protected ToolManager getToolManager() {
        return LangCore.getToolManager();
    }

    protected void deleteProjectBuildMarkers() {
        try {
            this.getProject().deleteMarkers("com.googlecode.goclipse.core.goProblem", true, 2);
        }
        catch (CoreException ce) {
            EclipseCore.logStatus(ce);
        }
    }

    protected String getBuildProblemId() {
        return "com.googlecode.goclipse.core.goProblem";
    }

    protected boolean isFirstProjectOfKind() throws CoreException {
        IBuildConfiguration[] iBuildConfigurationArray = this.getContext().getAllReferencedBuildConfigs();
        int n = iBuildConfigurationArray.length;
        int n2 = 0;
        while (n2 < n) {
            IBuildConfiguration buildConfig = iBuildConfigurationArray[n2];
            if (buildConfig.getProject().hasNature("com.googlecode.goclipse.core.goNature")) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    protected boolean isLastProjectOfKind() throws CoreException {
        IBuildConfiguration[] iBuildConfigurationArray = this.getContext().getAllReferencingBuildConfigs();
        int n = iBuildConfigurationArray.length;
        int n2 = 0;
        while (n2 < n) {
            IBuildConfiguration buildConfig = iBuildConfigurationArray[n2];
            if (buildConfig.getProject().hasNature("com.googlecode.goclipse.core.goNature")) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    protected void startupOnInitialize() {
        Assert.AssertNamespace.assertTrue((this.getProject() != null ? 1 : 0) != 0);
    }

    protected void prepareForBuild(IProgressMonitor pm) throws CoreException, OperationCancellation {
        this.handleBeginWorkspaceBuild(pm);
    }

    protected void handleBeginWorkspaceBuild(IProgressMonitor pm) throws CoreException, OperationCancellation {
        this.workspaceOpMonitor = (ILangOperationsListener_Default.IToolOperationMonitor)workspaceOpMonitorMap.get((Object)"com.googlecode.goclipse.core.goNature");
        if (this.workspaceOpMonitor != null) {
            return;
        }
        this.workspaceOpMonitor = this.getToolManager().startNewBuildOperation();
        workspaceOpMonitorMap.put((Object)"com.googlecode.goclipse.core.goNature", (Object)this.workspaceOpMonitor);
        ResourceUtils.getWorkspace().addResourceChangeListener(new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                int type = event.getType();
                if (type == 16 || type == 8) {
                    LangProjectBuilder.this.workspaceOpMonitor = null;
                    workspaceOpMonitorMap.remove((Object)"com.googlecode.goclipse.core.goNature");
                    ResourceUtils.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
                }
            }
        }, 24);
        this.workspaceOpMonitor.writeInfoMessage(TextMessageUtils.headerVeryBig(MessageFormat.format("Starting {0} build", "Go")));
        this.clearWorkspaceErrorMarkers(pm);
    }

    protected void clearWorkspaceErrorMarkers(IProgressMonitor pm) throws CoreException, OperationCancellation {
        this.clearErrorMarkers(this.getProject(), pm);
        IBuildConfiguration[] iBuildConfigurationArray = this.getContext().getAllReferencingBuildConfigs();
        int n = iBuildConfigurationArray.length;
        int n2 = 0;
        while (n2 < n) {
            IBuildConfiguration buildConfig = iBuildConfigurationArray[n2];
            this.clearErrorMarkers(buildConfig.getProject(), pm);
            ++n2;
        }
    }

    protected void clearErrorMarkers(IProject project, IProgressMonitor pm) throws CoreException, OperationCancellation {
        Operation clearMarkersOp = this.buildManager.newProjectClearMarkersOperation(this.workspaceOpMonitor, project);
        EclipseUtils.execute_asCore(EclipseUtils.om(pm), clearMarkersOp);
    }

    protected void handleEndWorkspaceBuild2() {
        this.workspaceOpMonitor = null;
    }

    protected IProject[] build(int kind, Map<String, String> args, IProgressMonitor monitor) throws CoreException {
        Assert.AssertNamespace.assertTrue((kind != 15 ? 1 : 0) != 0);
        IProject project = (IProject)Assert.AssertNamespace.assertNotNull((Object)this.getProject());
        try {
            this.prepareForBuild(monitor);
            IProject[] iProjectArray = this.doBuild(project, kind, args, monitor);
            return iProjectArray;
        }
        catch (OperationCancellation cancel) {
            this.forgetLastBuiltState();
            return null;
        }
        catch (CoreException ce) {
            this.forgetLastBuiltState();
            if (monitor.isCanceled()) {
                return null;
            }
            EclipseCore.logStatus(ce);
            throw ce;
        }
        finally {
            this.getProject().refreshLocal(2, monitor);
            if (this.isLastProjectOfKind()) {
                this.handleEndWorkspaceBuild2();
            }
        }
    }

    protected IProject[] doBuild(IProject project, int kind, Map<String, String> args, IProgressMonitor monitor) throws CoreException, OperationCancellation {
        if (kind == 9) {
            return null;
        }
        try {
            this.createBuildOp().execute(EclipseUtils.om(monitor));
        }
        catch (CommonException ce) {
            throw EclipseCore.createCoreException(ce);
        }
        return null;
    }

    protected Operation createBuildOp() throws CommonException {
        return this.buildManager.newProjectBuildOperation(this.workspaceOpMonitor, this.getProject(), false, false);
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        this.deleteProjectBuildMarkers();
        try {
            ProcessBuilder pb = this.createCleanPB();
            this.doClean(monitor, pb);
        }
        catch (OperationCancellation pb) {
        }
        catch (CommonException ce) {
            throw EclipseCore.createCoreException(ce);
        }
    }

    protected abstract ProcessBuilder createCleanPB() throws CoreException, CommonException;

    protected void doClean(IProgressMonitor pm, ProcessBuilder pb) throws CoreException, CommonException, OperationCancellation {
        this.getToolManager().newRunBuildToolOperation(pb, pm).runProcess();
    }
}

