/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.core.operations;

import melnorme.lang.ide.core.LangCore;
import melnorme.lang.ide.core.operations.ILangOperationsListener_Default;
import melnorme.lang.ide.core.operations.ToolManager;
import melnorme.lang.ide.core.utils.TextMessageUtils;
import melnorme.lang.tooling.common.ops.IOperationMonitor;
import melnorme.lang.tooling.common.ops.Operation;
import melnorme.utilbox.collections.Indexable;
import melnorme.utilbox.concurrency.ICancelMonitor;
import melnorme.utilbox.concurrency.OperationCancellation;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.core.CommonException;
import org.eclipse.core.resources.IProject;

public class RunToolOperation
implements Operation {
    protected final IProject project;
    protected final Indexable<String> commands;
    protected final ILangOperationsListener_Default.StartOperationOptions opViewOptions;
    protected ProcessBuilder pb;

    public RunToolOperation(IProject project, Indexable<String> commands, ILangOperationsListener_Default.StartOperationOptions opViewOptions) {
        this.project = project;
        this.commands = (Indexable)Assert.AssertNamespace.assertNotNull(commands);
        this.opViewOptions = (ILangOperationsListener_Default.StartOperationOptions)Assert.AssertNamespace.assertNotNull((Object)opViewOptions);
    }

    protected ToolManager getToolManager() {
        return LangCore.getToolManager();
    }

    public void execute(IOperationMonitor pm) throws CommonException, OperationCancellation {
        this.pb = this.createProcessBuilder();
        ILangOperationsListener_Default.IToolOperationMonitor opHandler = this.getToolManager().startNewOperation(this.opViewOptions);
        opHandler.writeInfoMessage(TextMessageUtils.headerBIG(this.getOperationStartMessage()));
        ToolManager.RunToolTask runToolTask = this.getToolManager().newRunProcessTask(opHandler, this.pb, (ICancelMonitor)pm);
        this.runProcessTask(runToolTask, pm);
    }

    protected ProcessBuilder createProcessBuilder() throws CommonException {
        return this.getToolManager().createSimpleProcessBuilder(this.project, this.getCommands());
    }

    protected String getOperationStartMessage() {
        return "Running command: ";
    }

    protected void runProcessTask(ToolManager.RunToolTask runToolTask, IOperationMonitor om) throws CommonException, OperationCancellation {
        runToolTask.runProcess();
    }

    protected String[] getCommands() {
        return (String[])this.commands.toArray(String.class);
    }

    public static class RunSDKToolOperation
    extends RunToolOperation {
        public RunSDKToolOperation(IProject project, Indexable<String> commands) {
            super(project, commands, new ILangOperationsListener_Default.StartOperationOptions(ILangOperationsListener_Default.ProcessStartKind.BUILD, true, true));
        }

        @Override
        protected ProcessBuilder createProcessBuilder() throws CommonException {
            return this.getToolManager().createSDKProcessBuilder(this.project, this.getCommands());
        }
    }
}

