/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.core.operations;

import java.nio.file.Path;
import java.util.Optional;
import melnorme.lang.ide.core.CoreSettings;
import melnorme.lang.ide.core.ILangOperationsListener;
import melnorme.lang.ide.core.LangCore;
import melnorme.lang.ide.core.operations.ILangOperationsListener_Default;
import melnorme.lang.ide.core.operations.build.VariablesResolver;
import melnorme.lang.ide.core.utils.EclipseUtils;
import melnorme.lang.ide.core.utils.ResourceUtils;
import melnorme.lang.ide.core.utils.process.AbstractRunProcessTask;
import melnorme.lang.tooling.toolchain.ops.IToolOperationService;
import melnorme.lang.utils.EnvUtils;
import melnorme.lang.utils.ProcessUtils;
import melnorme.lang.utils.validators.PathValidator;
import melnorme.utilbox.collections.ArrayList2;
import melnorme.utilbox.collections.Indexable;
import melnorme.utilbox.concurrency.ICancelMonitor;
import melnorme.utilbox.concurrency.OperationCancellation;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.core.CommonException;
import melnorme.utilbox.core.CoreUtil;
import melnorme.utilbox.fields.EventSource;
import melnorme.utilbox.misc.Location;
import melnorme.utilbox.misc.MiscUtil;
import melnorme.utilbox.misc.PathUtil;
import melnorme.utilbox.process.ExternalProcessHelper;
import melnorme.utilbox.status.StatusException;
import melnorme.utilbox.status.StatusLevel;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;

public abstract class ToolManager
extends EventSource<ILangOperationsListener> {
    protected final CoreSettings settings;
    protected final IStringVariableManager globalVarManager = VariablesPlugin.getDefault().getStringVariableManager();

    public ToolManager(CoreSettings settings) {
        this.settings = (CoreSettings)Assert.AssertNamespace.assertNotNull((Object)settings);
    }

    public void shutdownNow() {
    }

    public Path getSDKToolPath(IProject project) throws CommonException {
        return this.settings.SDK_LOCATION.getValue(project);
    }

    public PathValidator getSDKToolPathValidator() {
        return this.settings.getSDKLocationValidator();
    }

    public VariablesResolver getVariablesManager(Optional<IProject> project) {
        project = MiscUtil.toOptional(project);
        VariablesResolver variablesResolver = new VariablesResolver(this.globalVarManager);
        this.setupVariableResolver(variablesResolver, project);
        return variablesResolver;
    }

    protected void setupVariableResolver(VariablesResolver variablesResolver, Optional<IProject> project) {
        CoreSettings.SettingsField<Path> pref = LangCore.settings().SDK_LOCATION;
        variablesResolver.putDynamicVar(new VariablesResolver.SupplierAdapterVar("GO_TOOL_PATH", "The path of the Go tool", pref.getRawValueSupplier(project), pref.getValidator_toString()));
    }

    public ProcessBuilder createSDKProcessBuilder(IProject project, String ... sdkOptions) throws CommonException {
        Path sdkToolPath = this.getSDKToolPath(project);
        return this.createToolProcessBuilder(project, sdkToolPath, sdkOptions);
    }

    public final ProcessBuilder createToolProcessBuilder(IProject project, Path toolPath, String ... toolArguments) throws CommonException {
        Location projectLocation = project == null ? null : ResourceUtils.getProjectLocation2(project);
        ArrayList2 commandLine = ProcessUtils.createCommandLine((Path)toolPath, (String[])toolArguments);
        return this.createToolProcessBuilder((Indexable<String>)commandLine, projectLocation);
    }

    public ProcessBuilder createToolProcessBuilder(Indexable<String> commandLine, Location workingDir) {
        return this.modifyToolProcessBuilder(ProcessUtils.createProcessBuilder(commandLine, (Location)workingDir));
    }

    public ProcessBuilder modifyToolProcessBuilder(ProcessBuilder pb) {
        Path cmdExePath = PathUtil.createPathOrNull((String)pb.command().get(0));
        EnvUtils.addCmdDirToPathEnv((Path)cmdExePath, (ProcessBuilder)pb);
        return pb;
    }

    public ProcessBuilder createSimpleProcessBuilder(IProject project, String ... commands) throws CommonException {
        Location workingDir = project == null ? null : ResourceUtils.getProjectLocation2(project);
        return ProcessUtils.createProcessBuilder((Indexable)CoreUtil.list((Object[])commands), (Location)workingDir);
    }

    public void logAndNotifyError(String title, StatusException ce) {
        this.logAndNotifyError(title, title, ce);
    }

    public void logAndNotifyError(String msgId, String title, StatusException ce) {
        LangCore.logError(title, ce);
        this.notifyMessage(msgId, ce.getSeverity().toStatusLevel(), title, ce.getMessage());
    }

    public void notifyMessage(StatusLevel statusLevel, String title, String message) {
        this.notifyMessage(null, statusLevel, title, message);
    }

    public void notifyMessage(String msgId, StatusLevel statusLevel, String title, String message) {
        for (ILangOperationsListener listener : this.getListeners()) {
            listener.notifyMessage(msgId, statusLevel, title, message);
        }
    }

    public ILangOperationsListener_Default.IToolOperationMonitor startNewBuildOperation() {
        return this.startNewBuildOperation(false);
    }

    public ILangOperationsListener_Default.IToolOperationMonitor startNewBuildOperation(boolean explicitConsoleNotify) {
        return this.startNewOperation(ILangOperationsListener_Default.ProcessStartKind.BUILD, true, explicitConsoleNotify);
    }

    public ILangOperationsListener_Default.IToolOperationMonitor startNewOperation(ILangOperationsListener_Default.ProcessStartKind kind, boolean clearConsole, boolean activateConsole) {
        return this.startNewOperation(new ILangOperationsListener_Default.StartOperationOptions(kind, clearConsole, activateConsole));
    }

    public ILangOperationsListener_Default.IToolOperationMonitor startNewOperation(ILangOperationsListener_Default.StartOperationOptions options) {
        AggregatedToolOperationMonitor aggregatedHandlers = new AggregatedToolOperationMonitor();
        for (ILangOperationsListener processListener : this.getListeners()) {
            ILangOperationsListener_Default.IToolOperationMonitor handler = processListener.beginOperation(options);
            aggregatedHandlers.monitors.add((Object)handler);
        }
        return aggregatedHandlers;
    }

    public final RunToolTask newRunBuildToolOperation(ProcessBuilder pb, IProgressMonitor pm) {
        ILangOperationsListener_Default.IToolOperationMonitor opHandler = this.startNewBuildOperation();
        return this.newRunProcessTask(opHandler, pb, pm);
    }

    public final RunToolTask newRunProcessTask(ILangOperationsListener_Default.IToolOperationMonitor opMonitor, ProcessBuilder pb, IProgressMonitor pm) {
        return this.newRunProcessTask(opMonitor, pb, EclipseUtils.cm(pm));
    }

    public RunToolTask newRunProcessTask(ILangOperationsListener_Default.IToolOperationMonitor opMonitor, ProcessBuilder pb, ICancelMonitor cm) {
        String prefixText = ">> Running: ";
        return new RunToolTask(opMonitor, prefixText, pb, cm);
    }

    public ExternalProcessHelper.ExternalProcessResult runEngineTool(ProcessBuilder pb, String processInput, IProgressMonitor pm) throws CommonException, OperationCancellation {
        return this.runEngineTool(pb, processInput, EclipseUtils.cm(pm));
    }

    public final ExternalProcessHelper.ExternalProcessResult runEngineTool(ProcessBuilder pb, String processInput, ICancelMonitor cm) throws CommonException, OperationCancellation {
        ILangOperationsListener_Default.IToolOperationMonitor opMonitor = this.startNewOperation(ILangOperationsListener_Default.ProcessStartKind.ENGINE_TOOLS, false, false);
        return new RunToolTask(opMonitor, pb, cm).runProcess(processInput);
    }

    public IToolOperationService getEngineToolsOperationService() {
        return new ToolManagerEngineToolRunner();
    }

    public static class AggregatedToolOperationMonitor
    implements ILangOperationsListener_Default.IToolOperationMonitor {
        public final ArrayList2<ILangOperationsListener_Default.IToolOperationMonitor> monitors = new ArrayList2();

        @Override
        public void handleProcessStart(String prefixText, ProcessBuilder pb, AbstractRunProcessTask.ProcessStartHelper processStartHelper) {
            for (ILangOperationsListener_Default.IToolOperationMonitor monitor : this.monitors) {
                monitor.handleProcessStart(prefixText, pb, processStartHelper);
            }
        }

        @Override
        public void writeInfoMessage(String operationMessage) {
            for (ILangOperationsListener_Default.IToolOperationMonitor monitor : this.monitors) {
                monitor.writeInfoMessage(operationMessage);
            }
        }

        @Override
        public void activate() {
            for (ILangOperationsListener_Default.IToolOperationMonitor monitor : this.monitors) {
                monitor.activate();
            }
        }
    }

    public class RunToolTask
    extends AbstractRunProcessTask {
        protected final ILangOperationsListener_Default.IToolOperationMonitor opMonitor;
        protected final String prefixText;

        public RunToolTask(ILangOperationsListener_Default.IToolOperationMonitor opMonitor, ProcessBuilder pb, ICancelMonitor cm) {
            this(opMonitor, null, pb, cm);
        }

        public RunToolTask(ILangOperationsListener_Default.IToolOperationMonitor opMonitor, String prefixText, ProcessBuilder pb, ICancelMonitor cm) {
            super(pb, cm);
            this.prefixText = prefixText;
            this.opMonitor = (ILangOperationsListener_Default.IToolOperationMonitor)Assert.AssertNamespace.assertNotNull((Object)opMonitor);
        }

        @Override
        protected void handleProcessStartResult(AbstractRunProcessTask.ProcessStartHelper psh) {
            this.opMonitor.handleProcessStart(this.prefixText, this.pb, psh);
        }
    }

    public class ToolManagerEngineToolRunner
    implements IToolOperationService {
        public ExternalProcessHelper.ExternalProcessResult runProcess(ProcessBuilder pb, String processInput, ICancelMonitor cm) throws CommonException, OperationCancellation {
            return ToolManager.this.runEngineTool(pb, processInput, cm);
        }

        public void logStatus(StatusException statusException) {
            LangCore.logStatusException(statusException);
        }
    }
}

