/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.core.operations.build;

import melnorme.lang.ide.core.LangCore;
import melnorme.lang.ide.core.launch.LaunchMessages;
import melnorme.lang.ide.core.operations.ILangOperationsListener_Default;
import melnorme.lang.ide.core.operations.ToolManager;
import melnorme.lang.ide.core.operations.build.BuildManager;
import melnorme.lang.ide.core.operations.build.BuildTargetData;
import melnorme.lang.ide.core.operations.build.BuildTargetDataView;
import melnorme.lang.ide.core.operations.build.BuildTargetOperation;
import melnorme.lang.ide.core.operations.build.VariablesResolver;
import melnorme.lang.ide.core.utils.ResourceUtils;
import melnorme.lang.tooling.bundle.BuildConfiguration;
import melnorme.lang.tooling.bundle.BundleInfo;
import melnorme.lang.tooling.bundle.LaunchArtifact;
import melnorme.lang.tooling.commands.CommandInvocation;
import melnorme.lang.tooling.commands.IVariablesResolver;
import melnorme.lang.utils.validators.AbstractValidator;
import melnorme.lang.utils.validators.ValidationMessages;
import melnorme.utilbox.collections.Indexable;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.core.CommonException;
import melnorme.utilbox.core.CoreUtil;
import melnorme.utilbox.misc.Location;
import melnorme.utilbox.status.Severity;
import melnorme.utilbox.status.StatusException;
import org.eclipse.core.resources.IProject;

public class BuildTarget
extends AbstractValidator {
    public final BuildManager buildMgr = LangCore.getBuildManager();
    protected final IProject project;
    protected final BundleInfo bundleInfo;
    protected final BuildTargetDataView targetData;
    protected final BuildManager.BuildType buildType;
    protected final BuildConfiguration buildConfiguration;

    public static BuildTarget create(IProject project, BundleInfo bundleInfo, BuildTargetDataView buildTargetData, BuildManager.BuildType buildType, String buildConfigName) throws CommonException {
        BuildConfiguration buildConfig = buildType.getValidBuildconfiguration(buildConfigName, bundleInfo);
        return new BuildTarget(project, bundleInfo, buildTargetData, buildType, buildConfig);
    }

    public BuildTarget(IProject project, BundleInfo bundleInfo, BuildTargetDataView buildTargetData, BuildManager.BuildType buildType, BuildConfiguration buildConfig) {
        this.project = (IProject)Assert.AssertNamespace.assertNotNull((Object)project);
        this.bundleInfo = (BundleInfo)Assert.AssertNamespace.assertNotNull((Object)bundleInfo);
        this.targetData = (BuildTargetDataView)Assert.AssertNamespace.assertNotNull((Object)buildTargetData.copy());
        Assert.AssertNamespace.assertNotNull((Object)buildTargetData.getTargetName());
        this.buildType = (BuildManager.BuildType)Assert.AssertNamespace.assertNotNull((Object)buildType);
        this.buildConfiguration = (BuildConfiguration)Assert.AssertNamespace.assertNotNull((Object)buildConfig);
    }

    public BuildManager getBuildManager() {
        return this.buildMgr;
    }

    public IProject getProject() {
        return this.project;
    }

    public String toString() {
        return String.valueOf(this.project.getName()) + "//" + this.targetData.getTargetName();
    }

    public Location getProjectLocation() throws CommonException {
        return ResourceUtils.getProjectLocation2(this.project);
    }

    public String getBuildTargetName() {
        return (String)Assert.AssertNamespace.assertNotNull((Object)this.targetData.getTargetName());
    }

    public String getTargetName() {
        return (String)Assert.AssertNamespace.assertNotNull((Object)this.targetData.getTargetName());
    }

    public boolean isNormalBuildEnabled() {
        return this.targetData.isNormalBuildEnabled();
    }

    public boolean isAutoBuildEnabled() {
        return this.targetData.isAutoBuildEnabled();
    }

    public BuildTargetDataView getData() {
        return this.targetData;
    }

    public BuildTargetData getDataCopy() {
        return this.targetData.copy();
    }

    public String getBuildConfigName() {
        return this.buildConfiguration.getName();
    }

    public String getBuildTypeName() {
        return this.buildType.getName();
    }

    public BuildConfiguration getBuildConfiguration() {
        return this.buildConfiguration;
    }

    public BuildManager.BuildType getBuildType() {
        return this.buildType;
    }

    public boolean isDefaultBuildType() {
        return this.getBuildType() == this.buildMgr.getDefaultBuildType();
    }

    public BundleInfo getBundleInfo() {
        return this.bundleInfo;
    }

    public BuildTarget getDerivedBuildTarget(BuildTargetData data) {
        return new BuildTarget(this.getProject(), this.getBundleInfo(), data, this.getBuildType(), this.getBuildConfiguration());
    }

    public String getDefaultBuildCommand() throws StatusException {
        try {
            return this.getBuildType().getDefaultCommandLine(this);
        }
        catch (CommonException e) {
            throw e.toStatusException();
        }
    }

    public CommandInvocation getEffectiveBuildCommand2() throws StatusException {
        CommandInvocation buildCommand = this.targetData.getBuildCommand();
        if (buildCommand != null) {
            return buildCommand;
        }
        return new CommandInvocation(this.getDefaultBuildCommand());
    }

    public String getEffectiveValidExecutablePath() throws StatusException {
        String executablePath = this.targetData.getExecutablePath();
        if (executablePath != null) {
            return executablePath;
        }
        return this.getDefaultExecutablePath();
    }

    public String getDefaultExecutablePath() throws StatusException {
        LaunchArtifact mainLaunchArtifact = this.getMainLaunchArtifact();
        if (mainLaunchArtifact == null) {
            throw new StatusException(LaunchMessages.MSG_BuildTarget_NoExecutableAvailable());
        }
        return mainLaunchArtifact.getArtifactPath();
    }

    public Indexable<LaunchArtifact> getSubLaunchArtifacts() throws CommonException {
        return this.getBuildType().getSubTargetLaunchArtifacts(this);
    }

    public LaunchArtifact getMainLaunchArtifact() throws StatusException {
        try {
            return this.getBuildType().getMainLaunchArtifact(this);
        }
        catch (CommonException e) {
            throw e.toStatusException();
        }
    }

    public Location getValidExecutableLocation() throws StatusException {
        return this.getValidExecutableLocation(this.getEffectiveValidExecutablePath());
    }

    public Location getValidExecutableLocation(String exeFilePathString) throws StatusException {
        Location exeFileLocation;
        if (exeFilePathString == null || exeFilePathString.isEmpty()) {
            throw new StatusException("No path specified for the launch executable.");
        }
        try {
            exeFileLocation = Location.create((Location)this.getProjectLocation(), (String)exeFilePathString);
        }
        catch (CommonException e) {
            throw e.toStatusException();
        }
        if (exeFileLocation.toFile().exists() && !exeFileLocation.toFile().isFile()) {
            throw new StatusException(Severity.ERROR, ValidationMessages.Location_NotAFile((Location)exeFileLocation));
        }
        return exeFileLocation;
    }

    public void validateForBuild(ToolManager toolManager) throws StatusException {
        VariablesResolver variablesResolver = toolManager.getVariablesManager(CoreUtil.option((Object)this.getProject()));
        this.getEffectiveBuildCommand2().validate((IVariablesResolver)variablesResolver);
        this.getValidExecutableLocation();
    }

    public BuildTargetOperation getBuildOperation(ToolManager toolManager, ILangOperationsListener_Default.IToolOperationMonitor opMonitor) throws CommonException {
        Assert.AssertNamespace.assertNotNull((Object)opMonitor);
        return this.getBuildType().getBuildOperation(new BuildTargetOperation.BuildOperationParameters(opMonitor, toolManager, this.getProject(), this.getBuildTargetName(), this.getEffectiveBuildCommand2()));
    }
}

