/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.core.operations.build;

import melnorme.lang.ide.core.operations.build.BuildTarget;
import melnorme.lang.ide.core.operations.build.BuildTargetData;
import melnorme.lang.ide.core.operations.build.BuildTargetDataView;
import melnorme.lang.ide.core.operations.build.ProjectBuildInfo;
import melnorme.lang.ide.core.operations.build.VariablesResolver;
import melnorme.lang.tooling.commands.CommandInvocation;
import melnorme.lang.tooling.commands.CommandInvocationSerializer;
import melnorme.lang.utils.DocumentSerializerHelper;
import melnorme.utilbox.collections.ArrayList2;
import melnorme.utilbox.collections.Collection2;
import melnorme.utilbox.collections.Indexable;
import melnorme.utilbox.core.CommonException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class BuildTargetsSerializer
extends DocumentSerializerHelper<Indexable<? extends BuildTargetDataView>> {
    private static final String BUILD_TARGETS_ElemName = "build_targets";
    private static final String TARGET_ElemName = "target";
    private static final String PROP_NAME = "config";
    private static final String PROP_ENABLED = "n_enabled";
    private static final String PROP_AUTO_ENABLED = "auto_enabled";
    private static final String PROP_FORMAT_VERSION2 = "version2";
    private static final String PROP_ARGUMENTS = "options";
    private static final String PROP_EXE_PATH = "exe_path";
    protected final CommandInvocationSerializer commandSerializer = new CommandInvocationSerializer();

    public String writeProjectBuildInfo(ProjectBuildInfo projectBuildInfo) throws CommonException {
        Collection2<BuildTarget> buildTargets = projectBuildInfo.getBuildTargets();
        return this.writeToString(buildTargets.map(elem -> elem.getData()));
    }

    protected void writeDocument(Document doc, Indexable<? extends BuildTargetDataView> buildTargets) {
        Element buildTargetsElem = doc.createElementNS("com.googlecode.goclipse.core", BUILD_TARGETS_ElemName);
        doc.appendChild(buildTargetsElem);
        for (BuildTargetDataView buildTarget : buildTargets) {
            buildTargetsElem.appendChild(this.writeBuildTargetElement(doc, buildTarget));
        }
    }

    public ArrayList2<BuildTargetData> readFromString(String targetsXml) throws CommonException {
        return (ArrayList2)super.readFromString(targetsXml);
    }

    public ArrayList2<BuildTargetData> doReadFromString(String targetsXml) throws CommonException {
        Document doc = this.parseDocumentFromXml(targetsXml);
        Node buildTargetsElem = doc.getFirstChild();
        if (buildTargetsElem == null || !buildTargetsElem.getNodeName().equals(BUILD_TARGETS_ElemName)) {
            throw new CommonException("Expected element build_targets.");
        }
        ArrayList2 buildTargets = new ArrayList2();
        Node targetElem = buildTargetsElem.getFirstChild();
        while (targetElem != null) {
            if (targetElem.getNodeType() != 3) {
                buildTargets.add((Object)this.readBuildTargetElement(targetElem));
            }
            targetElem = targetElem.getNextSibling();
        }
        return buildTargets;
    }

    protected Element writeBuildTargetElement(Document doc, BuildTargetDataView btd) {
        Element targetElem = doc.createElement(TARGET_ElemName);
        targetElem.setAttribute(PROP_NAME, btd.getTargetName());
        targetElem.setAttribute(PROP_ENABLED, Boolean.toString(btd.isNormalBuildEnabled()));
        targetElem.setAttribute(PROP_AUTO_ENABLED, Boolean.toString(btd.isAutoBuildEnabled()));
        targetElem.setAttribute(PROP_FORMAT_VERSION2, "true");
        this.commandSerializer.writeToParent((Node)targetElem, btd.getBuildCommand());
        BuildTargetsSerializer.setAttribute((Element)targetElem, (String)PROP_EXE_PATH, (String)btd.getExecutablePath());
        return targetElem;
    }

    protected BuildTargetData readBuildTargetElement(Node targetElem) throws CommonException {
        String buildArgs_old;
        String nodeName = targetElem.getNodeName();
        if (!nodeName.equals(TARGET_ElemName)) {
            throw new CommonException("XML element not recognized : " + nodeName);
        }
        BuildTargetData buildTargetData = new BuildTargetData();
        buildTargetData.normalBuildEnabled = BuildTargetsSerializer.getBooleanAttribute((Node)targetElem, (String)PROP_ENABLED, (boolean)false);
        buildTargetData.autoBuildEnabled = BuildTargetsSerializer.getBooleanAttribute((Node)targetElem, (String)PROP_AUTO_ENABLED, (boolean)false);
        buildTargetData.targetName = BuildTargetsSerializer.getAttribute((Node)targetElem, (String)PROP_NAME, (String)"");
        int ix = 0;
        while (ix < targetElem.getChildNodes().getLength()) {
            Node node = targetElem.getChildNodes().item(ix);
            if (node.getNodeName().equals("command_invocation")) {
                buildTargetData.buildCommand = this.commandSerializer.readFromNode(node);
            }
            ++ix;
        }
        buildTargetData.executablePath = BuildTargetsSerializer.getAttribute((Node)targetElem, (String)PROP_EXE_PATH, null);
        if (BuildTargetsSerializer.getAttribute((Node)targetElem, (String)PROP_FORMAT_VERSION2, null) == null && (buildArgs_old = BuildTargetsSerializer.getAttribute((Node)targetElem, (String)PROP_ARGUMENTS, null)) != null) {
            buildTargetData.buildCommand = new CommandInvocation(String.valueOf(VariablesResolver.variableRefString("GO_TOOL_PATH")) + " " + buildArgs_old);
        }
        return this.createBuildTarget(targetElem, buildTargetData);
    }

    protected BuildTargetData createBuildTarget(Node targetElem, BuildTargetData buildTargetData) {
        return buildTargetData;
    }
}

