/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.core.operations.build;

import java.text.MessageFormat;
import java.util.function.Supplier;
import melnorme.lang.ide.core.EclipseCore;
import melnorme.lang.ide.core.utils.EclipseUtils;
import melnorme.lang.ide.core.utils.ForwardingVariableManager;
import melnorme.lang.ide.core.utils.StringSubstitutionEngine;
import melnorme.lang.tooling.commands.IVariablesResolver;
import melnorme.utilbox.collections.ArrayList2;
import melnorme.utilbox.collections.HashMap2;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.core.CommonException;
import melnorme.utilbox.fields.validation.Validator;
import melnorme.utilbox.status.StatusException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.variables.IDynamicVariable;
import org.eclipse.core.variables.IStringVariable;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.IValueVariable;

public class VariablesResolver
implements IVariablesResolver {
    protected final IStringVariableManager parentVarMgr;
    protected final OverlayVariableManager varMgr;

    public VariablesResolver(IStringVariableManager parentVarMgr) {
        this.parentVarMgr = (IStringVariableManager)Assert.AssertNamespace.assertNotNull((Object)parentVarMgr);
        this.varMgr = new OverlayVariableManager(parentVarMgr);
    }

    public String performStringSubstitution(String expression) throws CommonException {
        try {
            return this.varMgr.performStringSubstitution(expression, true);
        }
        catch (CoreException ce) {
            throw EclipseUtils.createCommonException(ce);
        }
    }

    public OverlayVariableManager getVariableManager() {
        return this.varMgr;
    }

    public Object[] getVariables() {
        return this.varMgr.getVariables();
    }

    public void putDynamicVar(IDynamicVariable dynamicVariable) {
        this.varMgr.putDynamicVar(dynamicVariable);
    }

    public void removeDynamicVar(String dynamicVariableName) {
        this.varMgr.removeDynamicVar(dynamicVariableName);
    }

    public static String variableRefString(String varName) {
        return "${" + varName + "}";
    }

    public static class OverlayVariableManager
    extends ForwardingVariableManager {
        protected final HashMap2<String, IDynamicVariable> dynamicVariables = new HashMap2();

        public OverlayVariableManager(IStringVariableManager parentVarMgr) {
            super(parentVarMgr);
        }

        @Override
        public IValueVariable getValueVariable(String name) {
            return super.getValueVariable(name);
        }

        @Override
        public IValueVariable[] getValueVariables() {
            return super.getValueVariables();
        }

        @Override
        public IDynamicVariable getDynamicVariable(String name) {
            IDynamicVariable variable = (IDynamicVariable)this.dynamicVariables.get((Object)name);
            if (variable != null) {
                return variable;
            }
            return super.getDynamicVariable(name);
        }

        @Override
        public IDynamicVariable[] getDynamicVariables() {
            IDynamicVariable[] parentVars;
            HashMap2 newMap = this.dynamicVariables.copyToHashMap();
            IDynamicVariable[] iDynamicVariableArray = parentVars = super.getDynamicVariables();
            int n = parentVars.length;
            int n2 = 0;
            while (n2 < n) {
                IDynamicVariable parentVar = iDynamicVariableArray[n2];
                newMap.putIfAbsent((Object)parentVar.getName(), (Object)parentVar);
                ++n2;
            }
            return (IDynamicVariable[])newMap.getValuesView().toArray(IDynamicVariable.class);
        }

        @Override
        public IStringVariable[] getVariables() {
            Object[] valueVars = this.getValueVariables();
            Object[] dynVars = this.getDynamicVariables();
            ArrayList2 variables = new ArrayList2(valueVars.length + dynVars.length);
            variables.addElements(dynVars);
            variables.addElements(valueVars);
            return (IStringVariable[])variables.toArray(IStringVariable.class);
        }

        public void putDynamicVar(IDynamicVariable dynamicVariable) {
            this.dynamicVariables.put((Object)dynamicVariable.getName(), (Object)dynamicVariable);
        }

        public void removeDynamicVar(String dynamicVariableName) {
            this.dynamicVariables.remove((Object)dynamicVariableName);
        }

        @Override
        public String performStringSubstitution(String expression, boolean reportUndefinedVariables) throws CoreException {
            return new StringSubstitutionEngine().performStringSubstitution(expression, reportUndefinedVariables, true, this);
        }
    }

    public static class SupplierAdapterVar
    implements IDynamicVariable {
        protected final String name;
        protected final String description;
        protected final Supplier<String> value;
        protected final Validator<String, String> validator;

        public SupplierAdapterVar(String name, String description, Supplier<String> value) {
            this(name, description, value, null);
        }

        public SupplierAdapterVar(String name, String description, Supplier<String> value, Validator<String, String> validator) {
            this.name = (String)Assert.AssertNamespace.assertNotNull((Object)name);
            this.description = (String)Assert.AssertNamespace.assertNotNull((Object)description);
            this.value = (Supplier)Assert.AssertNamespace.assertNotNull(value);
            this.validator = validator;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public boolean supportsArgument() {
            return false;
        }

        public String getValue(String argument) throws CoreException {
            if (argument != null) {
                throw EclipseCore.createCoreException(MessageFormat.format("Variable {0} does not accept arguments.", this.getName()), null);
            }
            if (this.validator != null) {
                try {
                    return (String)this.validator.validateField((Object)this.value.get());
                }
                catch (StatusException e) {
                    String msg = MessageFormat.format("Variable {0} error: {1}", this.getName(), e.getMessage());
                    throw EclipseCore.createCoreException(msg, e.getCause());
                }
            }
            return this.value.get();
        }
    }
}

