/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.core.project_model;

import melnorme.lang.ide.core.LangNature;
import melnorme.lang.ide.core.utils.DefaultProjectResourceListener;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;

public abstract class BundleManifestResourceListener
extends DefaultProjectResourceListener {
    public boolean isValidLangProject(IProject project) {
        return LangNature.isAccessible(project, true);
    }

    @Override
    protected void processProjectDelta(IResourceDelta projectDelta) {
        IProject project = (IProject)projectDelta.getResource();
        Object existingProjectInfo = this.getProjectInfo(project);
        if (projectDelta.getKind() == 2 || !this.isValidLangProject(project)) {
            if (existingProjectInfo == null) {
                return;
            }
            this.bundleProjectRemoved(project);
            return;
        }
        if (projectDelta.getKind() == 1) {
            this.tentativeAddBundleProject(project);
        } else if (projectDelta.getKind() == 4) {
            if (existingProjectInfo == null) {
                this.tentativeAddBundleProject(project);
                return;
            }
            IResourceDelta[] resourceDeltas = projectDelta.getAffectedChildren();
            if (resourceDeltas == null) {
                return;
            }
            IResourceDelta[] iResourceDeltaArray = resourceDeltas;
            int n = resourceDeltas.length;
            int n2 = 0;
            while (n2 < n) {
                IResourceDelta resourceDelta = iResourceDeltaArray[n2];
                if (this.resourceDeltaIsBundleManifestChange(resourceDelta)) {
                    this.bundleManifestChanged(project);
                }
                ++n2;
            }
        }
    }

    protected void tentativeAddBundleProject(IProject project) {
        if (this.isValidBundleModelProject(project)) {
            this.bundleProjectAdded(project);
        }
    }

    public boolean isValidBundleModelProject(IProject project) {
        return true;
    }

    public boolean resourceDeltaIsBundleManifestChange(IResourceDelta resourceDelta) {
        return this.resourceIsManifest(resourceDelta.getResource());
    }

    public abstract Object getProjectInfo(IProject var1);

    public abstract void bundleProjectAdded(IProject var1);

    public abstract void bundleProjectRemoved(IProject var1);

    public abstract void bundleManifestChanged(IProject var1);

    public abstract boolean resourceIsManifest(IResource var1);
}

