/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.core.project_model;

import java.util.HashSet;
import melnorme.lang.ide.core.project_model.CommonLangBundleModel;
import melnorme.lang.ide.core.project_model.IBundleModelManager;
import melnorme.lang.ide.core.project_model.LangBundleModel;
import melnorme.lang.ide.core.project_model.ProjectBasedModel;
import melnorme.lang.ide.core.project_model.ProjectBasedModelManager;
import melnorme.lang.ide.core.utils.CoreExecutors;
import melnorme.lang.tooling.bundle.BundleInfo;
import melnorme.utilbox.concurrency.ITaskAgent;
import melnorme.utilbox.concurrency.LatchRunnable;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.misc.SimpleLogger;
import melnorme.utilbox.ownership.Disposable;
import org.eclipse.core.resources.IProject;

public abstract class BundleModelManager<BUNDLE_MODEL extends LangBundleModel>
extends ProjectBasedModelManager
implements IBundleModelManager {
    protected final BUNDLE_MODEL model;
    protected final SimpleLogger log;
    protected final ITaskAgent modelAgent = CoreExecutors.newExecutorTaskAgent(this.getClass());
    protected final LatchRunnable startLatch = new LatchRunnable();
    protected final HashSet<IProject> ignoredProjects = new HashSet();

    public BundleModelManager(BUNDLE_MODEL model) {
        this.model = (LangBundleModel)Assert.AssertNamespace.assertNotNull(model);
        this.log = ((CommonLangBundleModel)model).getLog();
        this.initializeModelManagerWithModelAgent();
    }

    public ITaskAgent getModelAgent() {
        return this.modelAgent;
    }

    protected void initializeModelManagerWithModelAgent() {
        this.modelAgent.submitR((Runnable)this.startLatch);
        this.modelAgent.submitR(new Runnable(){

            @Override
            public void run() {
                BundleModelManager.this.initializeModelManager();
            }
        });
    }

    @Override
    public void startManager() {
        this.log.println(new Object[]{"==> Starting: " + this.getClass().getSimpleName()});
        this.startLatch.releaseAll();
    }

    protected void dispose_pre() {
        this.modelAgent.shutdownNowAndCancelAll();
    }

    public BUNDLE_MODEL getModel() {
        return this.model;
    }

    public BundleInfo getProjectInfo(IProject project) {
        return (BundleInfo)((ProjectBasedModel)this.model).getProjectInfo(project);
    }

    @Override
    protected void bundleProjectRemoved(IProject project) {
        ((ProjectBasedModel)this.model).removeProjectInfo(project);
    }

    @Override
    protected void bundleManifestFileChanged(IProject project) {
        this.bundleProjectAdded(project);
    }

    @Override
    protected final void bundleProjectAdded(IProject project) {
        if (this.ignoredProjects.contains(project)) {
            return;
        }
        this.handleBundleProjectAdded(project);
    }

    protected void handleBundleProjectAdded(IProject project) {
        ((ProjectBasedModel)this.model).setProjectInfo(project, (BundleInfo)this.createNewInfo(project));
    }

    protected abstract BundleInfo createNewInfo(IProject var1);

    public Disposable enableIgnoreProject(final IProject project) {
        this.ignoredProjects.add(project);
        return new Disposable(){

            public void dispose() {
                BundleModelManager.this.ignoredProjects.remove(project);
            }
        };
    }
}

