/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.core.project_model;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import melnorme.lang.ide.core.project_model.IProjectModelListener;
import melnorme.lang.ide.core.project_model.UpdateEvent;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.fields.ListenerListHelper;
import melnorme.utilbox.misc.SimpleLogger;
import org.eclipse.core.resources.IProject;

public abstract class ProjectBasedModel<INFO> {
    protected final HashMap<String, INFO> projectInfos = new HashMap();
    protected final ListenerListHelper<IProjectModelListener<INFO>> listeners = new ListenerListHelper();

    protected abstract SimpleLogger getLog();

    public void addListener(IProjectModelListener<? super INFO> listener) {
        this.listeners.addListener(listener.castTypeParam());
    }

    public void removeListener(IProjectModelListener<? super INFO> listener) {
        this.listeners.removeListener(listener.castTypeParam());
    }

    public synchronized HashMap<String, INFO> connectListener(IProjectModelListener<? super INFO> listener) {
        this.addListener(listener);
        return (HashMap)this.projectInfos.clone();
    }

    public synchronized INFO getProjectInfo(IProject project) {
        return this.projectInfos.get(project.getName());
    }

    public synchronized INFO setProjectInfo(IProject project, INFO newProjectInfo) {
        String projectName = project.getName();
        Assert.AssertNamespace.assertNotNull(newProjectInfo);
        this.projectInfos.put(projectName, newProjectInfo);
        this.notifyProjectInfoAdded(project, newProjectInfo);
        return newProjectInfo;
    }

    public synchronized boolean updateProjectInfo(IProject project, INFO oldProjectInfo, INFO newProjectInfo) {
        String projectName = project.getName();
        Assert.AssertNamespace.assertNotNull(newProjectInfo);
        if (this.projectInfos.get(projectName) == oldProjectInfo) {
            this.setProjectInfo(project, newProjectInfo);
            return true;
        }
        return false;
    }

    public synchronized INFO removeProjectInfo(IProject project) {
        INFO oldProjectInfo = this.projectInfos.remove(project.getName());
        if (oldProjectInfo != null) {
            this.notifyProjectRemoved(project, oldProjectInfo);
        }
        return oldProjectInfo;
    }

    public synchronized Set<String> getModelProjects() {
        return new HashSet<String>(this.projectInfos.keySet());
    }

    protected void notifyProjectInfoAdded(IProject project, INFO newProjectInfo) {
        this.getLog().println(new Object[]{String.valueOf(this.getClass().getSimpleName()) + " info set: " + project.getName()});
        this.fireUpdateEvent(new UpdateEvent<INFO>(project, newProjectInfo));
    }

    protected void notifyProjectRemoved(IProject project, INFO oldProjectInfo) {
        this.getLog().println(new Object[]{String.valueOf(this.getClass().getSimpleName()) + " info removed: " + project.getName()});
        this.fireUpdateEvent(new UpdateEvent<Object>(project, null));
    }

    protected void fireUpdateEvent(UpdateEvent<INFO> updateEvent) {
        for (IProjectModelListener listener : this.listeners.getListeners()) {
            listener.notifyUpdateEvent(updateEvent);
        }
    }
}

