/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.core.project_model.view;

import melnorme.lang.ide.core.project_model.view.AbstractBundleModelElement;
import melnorme.lang.ide.core.project_model.view.BundleModelElementKind;
import melnorme.lang.ide.core.project_model.view.IBundleModelElement;
import melnorme.utilbox.core.Assert;
import org.eclipse.core.resources.IProject;

public abstract class AbstractDependenciesContainer<BUNDLEINFO>
extends AbstractBundleModelElement<IProject> {
    protected final BUNDLEINFO bundleInfo;
    protected final IBundleModelElement[] depElements;

    public AbstractDependenciesContainer(BUNDLEINFO bundleInfo, IProject project) {
        super(project);
        this.bundleInfo = Assert.AssertNamespace.assertNotNull(bundleInfo);
        this.depElements = this.createChildren();
    }

    protected abstract IBundleModelElement[] createChildren();

    @Override
    public BundleModelElementKind getElementType() {
        return BundleModelElementKind.DEP_CONTAINER;
    }

    public BUNDLEINFO getBundleInfo() {
        return this.bundleInfo;
    }

    public IProject getProject() {
        return (IProject)this.getParent();
    }

    @Override
    public String getElementName() {
        return "{Dependencies}";
    }

    @Override
    public String getPathString() {
        return String.valueOf(this.getProject().getFullPath().toPortableString()) + "/" + this.getElementName();
    }

    @Override
    public boolean hasChildren() {
        return this.depElements.length > 0;
    }

    public IBundleModelElement[] getChildren() {
        return this.depElements;
    }
}

