/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.core.text;

import melnorme.utilbox.core.Assert;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.rules.RuleBasedScanner;

public class BufferedRuleBasedScannerExt
extends RuleBasedScanner {
    protected static final int DEFAULT_BUFFER_SIZE = 500;
    protected int fBufferSize = 500;
    protected char[] fBuffer = new char[500];
    protected int fStart;
    protected int fEnd;
    protected int fDocumentLength;

    protected BufferedRuleBasedScannerExt() {
    }

    public BufferedRuleBasedScannerExt(int size) {
        this.setBufferSize(size);
    }

    public int getOffset() {
        return this.fOffset;
    }

    protected void setBufferSize(int size) {
        Assert.isTrue((size > 0 ? 1 : 0) != 0);
        this.fBufferSize = size;
        this.fBuffer = new char[size];
    }

    protected void shiftBuffer(int offset) {
        this.fStart = offset;
        this.fEnd = this.fStart + this.fBufferSize;
        if (this.fEnd > this.fDocumentLength) {
            this.fEnd = this.fDocumentLength;
        }
        try {
            String content = this.fDocument.get(this.fStart, this.fEnd - this.fStart);
            content.getChars(0, this.fEnd - this.fStart, this.fBuffer, 0);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public void setRange(IDocument document, int offset, int length) {
        super.setRange(document, offset, length);
        this.fDocumentLength = document.getLength();
        this.shiftBuffer(offset);
    }

    public int read() {
        Assert.AssertNamespace.assertTrue((this.fOffset >= 0 ? 1 : 0) != 0);
        int next = this.charAt(this.fOffset);
        ++this.fOffset;
        this.fColumn = -1;
        return next;
    }

    public int lookahead(int offset) {
        return this.charAt(this.fOffset + offset);
    }

    protected int charAt(int offset) {
        if (offset >= this.fRangeEnd) {
            return -1;
        }
        if (this.offsetIsOutsideBuffer(offset)) {
            this.shiftBuffer(offset);
        }
        return this.fBuffer[offset - this.fStart];
    }

    public boolean offsetIsOutsideBuffer(int offset) {
        return offset < this.fStart || offset >= this.fEnd;
    }

    public String lookaheadString(int offset, int length) {
        try {
            Assert.AssertNamespace.assertTrue((this.fOffset + offset + length <= this.fRangeEnd ? 1 : 0) != 0);
            return this.fDocument.get(this.fOffset + offset, length);
        }
        catch (BadLocationException e) {
            throw Assert.AssertNamespace.assertFail();
        }
    }

    public void unread() {
        if (this.fOffset == this.fStart) {
            this.shiftBuffer(Math.max(0, this.fStart - this.fBufferSize / 2));
        }
        --this.fOffset;
        this.fColumn = -1;
        Assert.AssertNamespace.assertTrue((this.fOffset >= 0 ? 1 : 0) != 0);
    }
}

