/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.core.text;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;

public class JavaWordFinder {
    public static IRegion findWord(IDocument document, int offset) {
        int start = -2;
        int end = -1;
        try {
            char c;
            int pos = offset;
            while (pos >= 0) {
                c = document.getChar(pos);
                if (!Character.isJavaIdentifierPart(c) && !Character.isSurrogate(c)) break;
                --pos;
            }
            start = pos;
            pos = offset;
            int length = document.getLength();
            while (pos < length) {
                c = document.getChar(pos);
                if (!Character.isJavaIdentifierPart(c) && !Character.isSurrogate(c)) break;
                ++pos;
            }
            end = pos;
        }
        catch (BadLocationException pos) {
            // empty catch block
        }
        if (start >= -1 && end > -1) {
            if (start == offset && end == offset) {
                try {
                    char c = document.getChar(offset);
                    switch (c) {
                        case '-': {
                            if (document.getChar(offset + 1) == '>') {
                                return new Region(offset, 2);
                            }
                            break;
                        }
                        case '>': {
                            if (document.getChar(offset - 1) == '-') {
                                return new Region(offset - 1, 2);
                            }
                            break;
                        }
                        case ':': {
                            if (document.getChar(offset + 1) == ':') {
                                return new Region(offset, 2);
                            }
                            if (document.getChar(offset - 1) == ':') {
                                return new Region(offset - 1, 2);
                            }
                            break;
                        }
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
                return new Region(offset, 0);
            }
            if (start == offset) {
                return new Region(start, end - start);
            }
            return new Region(start + 1, end - start - 1);
        }
        return null;
    }
}

