/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.core.utils.operation;

import java.util.concurrent.CountDownLatch;
import melnorme.lang.ide.core.EclipseCore;
import melnorme.utilbox.core.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;

public class EclipseAsynchJobAdapter
extends Job {
    protected final CountDownLatch jobStartLatch = new CountDownLatch(1);
    protected volatile IProgressMonitor monitor;

    protected EclipseAsynchJobAdapter(String name) {
        super(name);
    }

    protected IStatus run(IProgressMonitor monitor) {
        this.monitor = monitor;
        this.jobStartLatch.countDown();
        return ASYNC_FINISH;
    }

    public static void runUnderAsynchJob(String jobName, IRunnableWithJob runnable) throws InterruptedException {
        EclipseAsynchJobAdapter job = new EclipseAsynchJobAdapter(jobName);
        job.schedule();
        try {
            job.jobStartLatch.await();
            Assert.AssertNamespace.assertNotNull((Object)job.monitor);
            job.setThread(Thread.currentThread());
            runnable.runUnderEclipseJob(job.monitor);
        }
        finally {
            job.done((IStatus)EclipseCore.createOkStatus(null));
        }
    }

    public static interface IRunnableWithJob {
        public void runUnderEclipseJob(IProgressMonitor var1);
    }
}

