/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.core.utils.prefs;

import java.util.Optional;
import java.util.function.Supplier;
import melnorme.lang.ide.core.LangCore;
import melnorme.lang.ide.core.SettingsChangeListener;
import melnorme.lang.ide.core.utils.prefs.PreferenceHelper;
import melnorme.lang.tooling.LocationHandle;
import melnorme.utilbox.core.CommonException;
import melnorme.utilbox.ownership.IDisposable;
import org.eclipse.core.resources.IProject;

public interface IProjectPreference<T> {
    public PreferenceHelper<T> getGlobalPreference();

    default public String getKey() {
        return this.getGlobalPreference().key;
    }

    public T getDefaultValue();

    public T getStoredValue(Optional<IProject> var1);

    public void doSetValue(IProject var1, T var2);

    public void setValue(IProject var1, T var2) throws CommonException;

    public T getEffectiveValue(Optional<IProject> var1);

    public IProjectPreference<Boolean> getEnableProjectSettingPref();

    public Supplier<T> getEffectiveValueProperty(Optional<IProject> var1);

    default public IDisposable addListener(final SettingChangeListener2<T> changeListener) {
        SettingsChangeListener settingsListener = new SettingsChangeListener(){

            @Override
            public void preferenceChanged(IProjectPreference<?> setting, LocationHandle location, Object newValue) {
                if (setting == IProjectPreference.this) {
                    changeListener.preferenceChanged(location, newValue);
                }
            }
        };
        return LangCore.settings().addSettingsListener(settingsListener);
    }

    public static interface SettingChangeListener2<T> {
        public void preferenceChanged(LocationHandle var1, T var2);
    }
}

