/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.core.utils.process;

import melnorme.lang.ide.core.LangCore;
import melnorme.lang.ide.core.utils.process.IRunProcessTask;
import melnorme.utilbox.collections.ArrayList2;
import melnorme.utilbox.concurrency.ICancelMonitor;
import melnorme.utilbox.concurrency.OperationCancellation;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.core.CommonException;
import melnorme.utilbox.misc.StringUtil;
import melnorme.utilbox.process.ExternalProcessHelper;
import melnorme.utilbox.process.ExternalProcessNotifyingHelper;

public abstract class AbstractRunProcessTask
implements IRunProcessTask {
    protected final ProcessBuilder pb;
    protected final ICancelMonitor cancelMonitor;
    protected ArrayList2<ExternalProcessNotifyingHelper.IProcessOutputListener> processListeners = new ArrayList2();

    public AbstractRunProcessTask(ProcessBuilder pb, ICancelMonitor cancelMonitor) {
        this.pb = (ProcessBuilder)Assert.AssertNamespace.assertNotNull((Object)pb);
        this.cancelMonitor = (ICancelMonitor)Assert.AssertNamespace.assertNotNull((Object)cancelMonitor);
    }

    public ExternalProcessNotifyingHelper startProcess() throws CommonException, OperationCancellation {
        Process process;
        ICancelMonitor.checkCancelation((ICancelMonitor)this.cancelMonitor);
        try {
            process = ExternalProcessNotifyingHelper.startProcess((ProcessBuilder)this.pb);
        }
        catch (CommonException ce) {
            this.handleProcessStartResult(new ProcessStartHelper(){

                @Override
                public void addProcessListener(ExternalProcessNotifyingHelper.IProcessOutputListener listener) throws CommonException {
                    throw ce;
                }
            });
            throw ce;
        }
        return this.readFromStartedProcess(process, this.cancelMonitor);
    }

    protected ExternalProcessNotifyingHelper readFromStartedProcess(Process process, ICancelMonitor pm) {
        this.handleProcessStartResult(new ProcessStartHelper(){

            @Override
            public void addProcessListener(ExternalProcessNotifyingHelper.IProcessOutputListener listener) throws CommonException {
                Assert.AssertNamespace.assertNotNull(AbstractRunProcessTask.this.processListeners);
                AbstractRunProcessTask.this.processListeners.add((Object)listener);
            }
        });
        try {
            ExternalProcessNotifyingHelper externalProcessNotifyingHelper = new ExternalProcessNotifyingHelper(process, true, pm, this.processListeners, LangCore.log());
            return externalProcessNotifyingHelper;
        }
        finally {
            this.processListeners = null;
        }
    }

    protected abstract void handleProcessStartResult(ProcessStartHelper var1);

    @Override
    public ExternalProcessHelper.ExternalProcessResult call() throws CommonException, OperationCancellation {
        return this.runProcess();
    }

    public ExternalProcessHelper.ExternalProcessResult runProcess() throws CommonException, OperationCancellation {
        return this.runProcess(null);
    }

    public ExternalProcessHelper.ExternalProcessResult runProcess(String input) throws CommonException, OperationCancellation {
        return this.doRunProcess(input);
    }

    public ExternalProcessHelper.ExternalProcessResult doRunProcess(String input) throws CommonException, OperationCancellation {
        ExternalProcessNotifyingHelper processHelper = this.startProcess();
        processHelper.writeInput_(input, StringUtil.UTF8);
        ExternalProcessHelper.ExternalProcessResult processResult = processHelper.awaitTerminationAndResult_ce();
        return processResult;
    }

    public static interface ProcessStartHelper {
        public void addProcessListener(ExternalProcessNotifyingHelper.IProcessOutputListener var1) throws CommonException;
    }
}

