/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.goclipse.tooling;

import com.googlecode.goclipse.tooling.CommonGoToolingTest;
import com.googlecode.goclipse.tooling.GoBuildOutputProcessor;
import java.nio.file.Path;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import melnorme.lang.tests.LangToolingTestResources;
import melnorme.lang.tooling.common.SourceLineColumnRange;
import melnorme.lang.tooling.common.ToolSourceMessage;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.core.CommonException;
import melnorme.utilbox.core.CoreUtil;
import melnorme.utilbox.status.Severity;
import org.junit.Test;

public class GoBuildOutputProcessorTest
extends CommonGoToolingTest {
    protected static final Path BUILD_OUTPUT_TestResources = LangToolingTestResources.getTestResourcePath("buildOutput");

    protected static ToolSourceMessage warning(Path path, int line, int column, String errorMessage) {
        return new ToolSourceMessage(path, new SourceLineColumnRange(line, column), Severity.WARNING, errorMessage);
    }

    protected static ToolSourceMessage error(Path path, int line, int column, String errorMessage) {
        return new ToolSourceMessage(path, new SourceLineColumnRange(line, column), Severity.ERROR, errorMessage);
    }

    @Test
    public void test() throws Exception {
        this.test$();
    }

    public void test$() throws Exception {
        this.runTest();
        this.runInvalidSyntaxTest();
    }

    protected void runTest() throws CommonException {
        GoBuildOutputProcessor buildProcessor = new GoBuildOutputProcessor(){

            @Override
            protected void handleParseError(CommonException ce) {
                Assert.AssertNamespace.assertFail();
            }
        };
        this.testParseError(buildProcessor, "", CoreUtil.listFrom(new Object[0]));
        this.testParseError(buildProcessor, "asdfsdaf/asdfsd", CoreUtil.listFrom(new Object[0]));
        this.testParseError(buildProcessor, this.readTemplatedFile(BUILD_OUTPUT_TestResources.resolve("outputA.txt")), CoreUtil.listFrom(GoBuildOutputProcessorTest.error(GoBuildOutputProcessorTest.path("MyGoLibFoo/libfoo/blah.go"), 7, -1, "undefined: asdfsd"), GoBuildOutputProcessorTest.error(GoBuildOutputProcessorTest.path("MyGoLibFoo/libfoo/blah.go"), 10, -1, "not enough arguments in call to fmt.Printf"), GoBuildOutputProcessorTest.error(GoBuildOutputProcessorTest.path("MyGoLibFoo/foo.go"), 3, -1, "undefined: ziggy"), GoBuildOutputProcessorTest.error(GoBuildOutputProcessorTest.TR_SAMPLE_GOPATH_ENTRY.resolve_valid((String)"src/samplePackage/foo.go").path, 5, -1, "undefined: ziggy2")));
        String OUTPUT_B = this.readTemplatedFile(BUILD_OUTPUT_TestResources.resolve("outputB.txt"));
        String errorMessage1 = GoBuildOutputProcessorTest.findMatch(OUTPUT_B, "cannot find package \"xxx.*\\n.*\\n.*", 0).replace("\r", "");
        String errorMessage2 = GoBuildOutputProcessorTest.findMatch(OUTPUT_B, "cannot find package \"yyy.*\\n.*\\n.*", 0).replace("\r", "");
        String errorMessage3 = GoBuildOutputProcessorTest.findMatch(OUTPUT_B, "cannot find package \"zzz.*\\n.*\\n.*", 0).replace("\r", "");
        List<ToolSourceMessage> OUTPUTB_Errors = CoreUtil.listFrom(GoBuildOutputProcessorTest.error(GoBuildOutputProcessorTest.path("libbar/blah.go"), 3, 8, errorMessage1), GoBuildOutputProcessorTest.error(GoBuildOutputProcessorTest.path("../MyGoLibFoo/libfoo/blah.go"), 3, 8, errorMessage2), GoBuildOutputProcessorTest.error(GoBuildOutputProcessorTest.TR_SAMPLE_GOPATH_ENTRY.resolve_valid((String)"src/samplePackage/foo.go").path, 3, 2, errorMessage3));
        this.testParseError(buildProcessor, OUTPUT_B, OUTPUTB_Errors);
        this.testParseError(buildProcessor, "path/file:3:: <message> (<linter>)\npath/file:3:10: <message> (<linter>)\npath/file:4:11:warning: This is a warning!", CoreUtil.listFrom(GoBuildOutputProcessorTest.error(GoBuildOutputProcessorTest.path("path/file"), 3, -1, "<message> (<linter>)"), GoBuildOutputProcessorTest.error(GoBuildOutputProcessorTest.path("path/file"), 3, 10, "<message> (<linter>)"), GoBuildOutputProcessorTest.warning(GoBuildOutputProcessorTest.path("path/file"), 4, 11, "This is a warning!")));
    }

    protected void testParseError(GoBuildOutputProcessor buildProcessor, String stderr, List<?> expected) throws CommonException {
        Object buildMessages = buildProcessor.parseOutput(stderr);
        GoBuildOutputProcessorTest.assertEquals(buildMessages, expected);
    }

    protected String readTemplatedFile(Path filePath) {
        String fileContents = GoBuildOutputProcessorTest.readStringFromFile(filePath);
        return fileContents.replaceAll(Pattern.quote("$$TESTRESOURCE_SAMPLE_GOPATH_ENTRY$$"), Matcher.quoteReplacement(TR_SAMPLE_GOPATH_ENTRY.toString()));
    }

    protected void runInvalidSyntaxTest() throws CommonException {
        GoBuildOutputProcessor buildProcessor = new GoBuildOutputProcessor(){

            @Override
            protected void handleParseError(CommonException ce) {
            }
        };
        buildProcessor.parseOutput("libbar\blah.go:");
    }
}

