/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.goclipse.tooling;

import com.googlecode.goclipse.tooling.GoSourceFileUtil;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.core.CommonException;
import melnorme.utilbox.tests.CommonTest;
import org.junit.Test;

public class GoSourceFileUtilTest
extends CommonTest {
    @Test
    public void test() throws Exception {
        this.test$();
    }

    public void test$() throws Exception {
        this.testFindPackageDeclaration("package xxx");
        this.testFindPackageDeclaration("  package xxx");
        this.testFindPackageDeclaration("//  package zzzz\n package xxx");
        this.testFindPackageDeclaration("/*  package zzzz\n */  // package zzzz \n package xxx");
        this.testFindPackageDeclaration("/* ___ *//* ___ *///___\npackage xxx");
        this.testFindPackageDeclaration("/**/package xxx");
        GoSourceFileUtilTest.verifyThrows(() -> this.testFindPackageDeclaration("/*  ___ "), CommonException.class);
        GoSourceFileUtilTest.verifyThrows(() -> this.testFindPackageDeclaration("/**"), CommonException.class);
    }

    protected void testFindPackageDeclaration(String source) throws CommonException {
        int pkgNameStart = GoSourceFileUtil.findPackageDeclaration_NameStart(source);
        int expected = source.indexOf("package xxx");
        Assert.AssertNamespace.assertTrue(expected != -1);
        Assert.AssertNamespace.assertTrue(pkgNameStart != -1 && pkgNameStart == (expected += "package ".length()));
    }
}

