/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.goclipse.tooling.env;

import com.googlecode.goclipse.tooling.GoPackageName;
import com.googlecode.goclipse.tooling.env.GoEnvironment;
import com.googlecode.goclipse.tooling.env.GoWorkspaceLocation;
import java.io.File;
import java.util.Collection;
import java.util.LinkedHashSet;
import melnorme.utilbox.collections.ArrayList2;
import melnorme.utilbox.collections.Indexable;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.core.CommonException;
import melnorme.utilbox.misc.Location;
import melnorme.utilbox.misc.StringUtil;

public class GoPath {
    public static final String SRC_DIR = "src";
    protected final Indexable<String> goPathElements;

    public GoPath(String goPathString) {
        this(StringUtil.splitToList(goPathString, File.pathSeparator));
    }

    public GoPath(Collection<String> goPathElements) {
        LinkedHashSet<String> newElements = new LinkedHashSet<String>();
        for (String string : goPathElements) {
            if (string.isEmpty()) continue;
            newElements.add(string);
        }
        this.goPathElements = new ArrayList2<String>((Collection<String>)newElements);
    }

    public Indexable<String> getGoPathEntries() {
        return this.goPathElements;
    }

    public boolean isEmpty() {
        return this.goPathElements.size() == 0;
    }

    public void validate() throws CommonException {
        if (this.isEmpty()) {
            throw new CommonException("Invalid Go environment, GOPATH is empty.");
        }
    }

    public String asString() {
        return this.getGoPathString();
    }

    public String getGoPathString() {
        return StringUtil.collToString(this.goPathElements, File.pathSeparator);
    }

    public GoWorkspaceLocation findGoPathEntryAt(Location location) {
        Assert.AssertNamespace.assertNotNull(location);
        for (String pathElement : this.goPathElements) {
            Location pathElementLoc = Location.createValidOrNull(pathElement);
            if (pathElementLoc == null || !pathElementLoc.equals(location)) continue;
            return new GoWorkspaceLocation(pathElementLoc);
        }
        return null;
    }

    public GoWorkspaceLocation findGoPathEntry(Location goPathSubLocation) {
        if (goPathSubLocation == null) {
            return null;
        }
        for (String pathElement : this.goPathElements) {
            Location pathElementLoc = Location.createValidOrNull(pathElement);
            if (pathElementLoc == null || !goPathSubLocation.startsWith(pathElementLoc)) continue;
            return new GoWorkspaceLocation(pathElementLoc);
        }
        return null;
    }

    public GoWorkspaceLocation findGoPathEntryForSourceLocation(Location sourcePath) {
        GoWorkspaceLocation goWorkspace = this.findGoPathEntry(sourcePath);
        if (goWorkspace != null && sourcePath.startsWith(goWorkspace.getSrcLocation())) {
            return goWorkspace;
        }
        return null;
    }

    public GoPackageName findGoPackageForLocation(Location goPackageLocation) {
        GoWorkspaceLocation goPathEntry = this.findGoPathEntry(goPackageLocation);
        if (goPathEntry == null) {
            return null;
        }
        Location sourceRoot = goPathEntry.getSrcLocation();
        return GoEnvironment.getGoPackageForLocation(goPackageLocation, sourceRoot);
    }

    public static GoPackageName getGoPackageForPath(Location goPathEntry, Location packageLoc) {
        Location sourceRoot = goPathEntry.resolve_fromValid(SRC_DIR);
        if (!packageLoc.startsWith(goPathEntry)) {
            return null;
        }
        return GoPackageName.fromPath(sourceRoot.relativize(packageLoc));
    }

    public ArrayList2<GoPackageName> findGoSourcePackages(Location subLocation) {
        GoWorkspaceLocation workspaceEntry = this.findGoPathEntry(subLocation);
        if (workspaceEntry == null) {
            return new ArrayList2<GoPackageName>();
        }
        if (subLocation.equals(workspaceEntry.getLocation())) {
            subLocation = workspaceEntry.getSrcLocation();
        }
        return workspaceEntry.findSourcePackages(subLocation);
    }

    public Location getSourceRootforLocation(Location location) {
        GoWorkspaceLocation goPathEntryForLoc = this.findGoPathEntry(location);
        if (goPathEntryForLoc != null) {
            return goPathEntryForLoc.location.resolve_valid(SRC_DIR);
        }
        return null;
    }
}

