/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.goclipse.tooling.env;

import com.googlecode.goclipse.tooling.GoPackageName;
import com.googlecode.goclipse.tooling.env.GoEnvironment;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.core.CommonException;
import melnorme.utilbox.misc.Location;

public class GoRoot {
    protected final String goRootString;

    public GoRoot(String goRoot) {
        this.goRootString = Assert.AssertNamespace.assertNotNull(goRoot);
    }

    public String asString() {
        return this.goRootString;
    }

    public boolean isEmpty() {
        return this.goRootString.isEmpty();
    }

    public void validate() throws CommonException {
        if (this.isEmpty()) {
            throw new CommonException("Invalid Go environment, GOROOT is empty.");
        }
    }

    public Location asLocation() throws CommonException {
        if (this.isEmpty()) {
            throw new CommonException("GOROOT is not defined.");
        }
        return Location.createValidLocation(this.goRootString, "Invalid GOROOT: ");
    }

    public Location getSourceRootLocation() throws CommonException {
        Location loc = this.asLocation().resolve_fromValid("src/pkg");
        if (loc.toFile().isDirectory()) {
            return loc;
        }
        return this.asLocation().resolve_fromValid("src");
    }

    public GoPackageName findGoPackageForLocation(Location goPackageLocation) throws CommonException {
        return GoEnvironment.getGoPackageForLocation(goPackageLocation, this.getSourceRootLocation());
    }
}

