/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.goclipse.tooling.env;

import com.googlecode.goclipse.tooling.GoPackageName;
import com.googlecode.goclipse.tooling.GoPackagesVisitor;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import melnorme.utilbox.collections.ArrayList2;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.core.CommonException;
import melnorme.utilbox.core.CoreUtil;
import melnorme.utilbox.misc.HashcodeUtil;
import melnorme.utilbox.misc.Location;

public class GoWorkspaceLocation {
    protected final Location location;

    public GoWorkspaceLocation(Location location) {
        this.location = Assert.AssertNamespace.assertNotNull(location);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof GoWorkspaceLocation)) {
            return false;
        }
        GoWorkspaceLocation other = (GoWorkspaceLocation)obj;
        return CoreUtil.areEqual(this.location, other.location);
    }

    public int hashCode() {
        return HashcodeUtil.combinedHashCode(this.location);
    }

    public String toString() {
        return this.location.toPathString();
    }

    public Location getLocation() {
        return this.location;
    }

    public Location getBinLocation() {
        return this.location.resolve_valid("bin");
    }

    public Location getSrcLocation() {
        return this.location.resolve_valid("src");
    }

    public Location getGoPackageLocation(String goPackageName) throws CommonException {
        GoPackageName goPackage = new GoPackageName(goPackageName);
        return this.getSrcLocation().resolve(goPackage.getFullNameAsString());
    }

    public ArrayList2<GoPackageName> findSourcePackages(Location directory) {
        GoPackagesVisitor goPackagesVisitor = new GoPackagesVisitor(this, directory){

            @Override
            protected FileVisitResult handleFileVisitException(Path file, IOException exc) {
                return FileVisitResult.CONTINUE;
            }
        };
        return new ArrayList2<GoPackageName>(goPackagesVisitor.getModuleNames());
    }

    public ArrayList2<GoPackageName> findSubPackages(String parentGoPackage) throws CommonException {
        Location goPackageLocation = this.getGoPackageLocation(parentGoPackage);
        return this.findSourcePackages(goPackageLocation);
    }
}

