/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.goclipse.tooling.gocode;

import com.googlecode.goclipse.tooling.env.GoEnvironment;
import java.util.regex.Pattern;
import melnorme.lang.tooling.common.ops.IProcessRunner;
import melnorme.lang.tooling.toolchain.ops.ToolOutputParseHelper;
import melnorme.utilbox.collections.ArrayList2;
import melnorme.utilbox.concurrency.ICancelMonitor;
import melnorme.utilbox.concurrency.OperationCancellation;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.core.CommonException;
import melnorme.utilbox.process.ExternalProcessHelper;

public class GocodeCompletionOperation
implements ToolOutputParseHelper {
    public static final boolean USE_TCP = true;
    protected final IProcessRunner toolRunner;
    protected final GoEnvironment goEnvironment;
    protected final String gocodePath;
    protected final ICancelMonitor cm;
    public static final Pattern LINE_SPLITTER = Pattern.compile("\n|(\r\n)|\r");

    public GocodeCompletionOperation(IProcessRunner toolRunner, GoEnvironment goEnvironment, String gocodePath, ICancelMonitor cm) {
        this.toolRunner = Assert.AssertNamespace.assertNotNull(toolRunner);
        this.goEnvironment = Assert.AssertNamespace.assertNotNull(goEnvironment);
        this.gocodePath = Assert.AssertNamespace.assertNotNull(gocodePath);
        this.cm = Assert.AssertNamespace.assertNotNull(cm);
    }

    protected void setLibPathForEnvironment() throws CommonException, OperationCancellation {
        ArrayList2<String> arguments = new ArrayList2<String>(this.gocodePath);
        arguments.add("-sock=tcp");
        arguments.add("set");
        arguments.add("lib-path");
        arguments.add(this.goEnvironment.getGoPathString());
        ProcessBuilder pb = this.goEnvironment.createProcessBuilder(arguments, null, true);
        this.toolRunner.runProcess(pb, null, this.cm);
    }

    public ExternalProcessHelper.ExternalProcessResult execute(String filePath, String bufferText, int offset) throws CommonException, OperationCancellation {
        this.setLibPathForEnvironment();
        ArrayList2<String> arguments = new ArrayList2<String>(this.gocodePath);
        arguments.add("-sock=tcp");
        arguments.add("-f=csv");
        arguments.add("autocomplete");
        arguments.add(filePath);
        arguments.add("c" + offset);
        ProcessBuilder pb = this.goEnvironment.createProcessBuilder(arguments, null, true);
        return this.toolRunner.runProcess(pb, bufferText, this.cm);
    }
}

