/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.goclipse.tooling.gocode;

import com.googlecode.goclipse.tooling.gocode.GocodeOutputParser2;
import melnorme.lang.tooling.CompletionProposalKind;
import melnorme.lang.tooling.EAttributeFlag;
import melnorme.lang.tooling.EProtection;
import melnorme.lang.tooling.ElementAttributes;
import melnorme.lang.tooling.ToolCompletionProposal;
import melnorme.lang.tooling.ast.SourceRange;
import melnorme.utilbox.collections.Indexable;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.core.CommonException;
import melnorme.utilbox.tests.CommonTestExt;
import org.junit.Test;

public class GocodeOutputParser_Test
extends CommonTestExt {
    protected ElementAttributes attribs(EProtection protection) {
        return new ElementAttributes(protection, new EAttributeFlag[0]);
    }

    protected SourceRange sr(int offset, int length) {
        return new SourceRange(offset, length);
    }

    @Test
    public void test() throws Exception {
        this.test$();
    }

    public void test$() throws Exception {
        this.testProposalParse("var,,xxx,,int", this.proposal("xxx", "xxx", CompletionProposalKind.VARIABLE, this.attribs(EProtection.PRIVATE), ": int"));
        this.testProposalParse("var,,Global,,", this.proposal("Global", "Global", CompletionProposalKind.VARIABLE, this.attribs(null), null));
        this.testProposalParse("const,,xxx,,int", this.proposal("xxx", "xxx", CompletionProposalKind.VARIABLE, new ElementAttributes(EProtection.PRIVATE, EAttributeFlag.CONST), ": int"));
        this.testProposalParse("type,,Foo,,struct", this.proposal("Foo", "Foo", CompletionProposalKind.STRUCT, this.attribs(null), null));
        this.testProposalParse("type,,Foo,,interface", this.proposal("Foo", "Foo", CompletionProposalKind.INTERFACE, this.attribs(null), null));
        this.testProposalParse("type,,Type,,map[string][]string", this.proposal("Type", "Type", CompletionProposalKind.TYPE_DECL, this.attribs(null), ": map[string][]string"));
        this.testProposalParse("type,,int16,,built-in", this.proposal("int16", "int16", CompletionProposalKind.NATIVE, this.attribs(null), null));
        this.testProposalParse("package,,fmt,,", this.proposal("fmt", "fmt", CompletionProposalKind.PACKAGE, this.attribs(null), null));
        this.testProposalParse("func,,xpto,,func() int", this.fnProposal("xpto", "xpto()", null, "xpto()", CompletionProposalKind.FUNCTION, this.attribs(EProtection.PRIVATE), "int"));
        this.testProposalParse("func,,xpto,,func() (int, string)", this.fnProposal("xpto", "xpto()", null, "xpto()", CompletionProposalKind.FUNCTION, this.attribs(EProtection.PRIVATE), "(int, string)"));
        this.testProposalParse("func,,ApiFunc,,func()", this.fnProposal("ApiFunc", "ApiFunc()", null, "ApiFunc()", CompletionProposalKind.FUNCTION, this.attribs(null), ""));
        this.testProposalParse("func,,xpto,,func", this.fnProposal("xpto", "xpto", null, "xpto", CompletionProposalKind.FUNCTION, this.attribs(EProtection.PRIVATE), null));
        this.testProposalParse("func,,ApiFunc,,func(writer io.Writer)", this.fnProposal("ApiFunc", "ApiFunc(writer)", GocodeOutputParser_Test.list(this.sr(8, 6)), "ApiFunc(writer io.Writer)", CompletionProposalKind.FUNCTION, this.attribs(null), ""));
        this.testProposalParse("func,,ApiFunc,,func(writer io.Writer, a ...interface{})", this.fnProposal("ApiFunc", "ApiFunc(writer, a)", GocodeOutputParser_Test.list(this.sr(8, 6), this.sr(16, 1)), "ApiFunc(writer io.Writer, a ...interface{})", CompletionProposalKind.FUNCTION, this.attribs(null), ""));
        this.testProposalParse("func,,ApiFunc,,func(writer, a ...interface{})", this.fnProposal("ApiFunc", "ApiFunc(writer, a)", GocodeOutputParser_Test.list(this.sr(8, 6), this.sr(16, 1)), "ApiFunc(writer, a ...interface{})", CompletionProposalKind.FUNCTION, this.attribs(null), ""));
    }

    protected ToolCompletionProposal proposal(String replaceString, String label, CompletionProposalKind kind, ElementAttributes attribs, String typeLabel) {
        return new ToolCompletionProposal(4, 6, replaceString, label, kind, attribs, typeLabel, null, null);
    }

    protected ToolCompletionProposal fnProposal(String simpleReplaceString, String fullReplaceString, Indexable<SourceRange> sourceSubElements, String label, CompletionProposalKind kind, ElementAttributes attribs, String typeLabel) {
        return new ToolCompletionProposal(4, 6, simpleReplaceString, label, kind, attribs, typeLabel, null, null, fullReplaceString, sourceSubElements);
    }

    protected void testProposalParse(String gocodeResultLine, ToolCompletionProposal expectedProposal) throws CommonException {
        GocodeOutputParser2 outputParser = new GocodeOutputParser2(10, "    prefix"){

            @Override
            protected void logWarning(String message) {
                Assert.AssertNamespace.assertFail();
            }
        };
        ToolCompletionProposal completion = outputParser.parseCompletion(gocodeResultLine);
        GocodeOutputParser_Test.assertAreEqual(completion.getTypeLabel(), expectedProposal.getTypeLabel());
        GocodeOutputParser_Test.assertAreEqual(completion.getFullReplaceString(), expectedProposal.getFullReplaceString());
        GocodeOutputParser_Test.assertAreEqual(completion.getSourceSubElements(), expectedProposal.getSourceSubElements());
        Assert.AssertNamespace.assertTrue(completion.equals(expectedProposal));
    }
}

