/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.goclipse.tooling.oracle;

import com.googlecode.goclipse.tooling.env.GoEnvironment;
import com.googlecode.goclipse.tooling.oracle.GoOperationContext;
import melnorme.lang.tooling.toolchain.ops.AbstractToolInvocationOperation;
import melnorme.lang.tooling.toolchain.ops.OperationSoftFailure;
import melnorme.lang.tooling.toolchain.ops.SourceLocation;
import melnorme.lang.tooling.toolchain.ops.SourceOpContext;
import melnorme.lang.tooling.toolchain.ops.ToolOutputParseHelper;
import melnorme.lang.utils.parse.StringCharSource;
import melnorme.utilbox.collections.ArrayList2;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.core.CommonException;
import melnorme.utilbox.misc.Location;
import melnorme.utilbox.misc.StringUtil;
import melnorme.utilbox.process.ExternalProcessHelper;

public class GodefOperation
extends AbstractToolInvocationOperation<SourceLocation> {
    protected GoOperationContext goOpContext;
    protected GoEnvironment goEnv;
    protected SourceOpContext opContext;

    public GodefOperation(GoOperationContext goOpContext, String godefPath) {
        super(goOpContext.getToolOpService(), godefPath);
        this.goOpContext = Assert.AssertNamespace.assertNotNull(goOpContext);
        this.goEnv = Assert.AssertNamespace.assertNotNull(goOpContext.getGoEnv());
        this.opContext = Assert.AssertNamespace.assertNotNull(goOpContext.opContext);
    }

    @Override
    protected String getToolName() throws CommonException {
        return "godef";
    }

    @Override
    protected ProcessBuilder createProcessBuilder() throws CommonException {
        Location toolLoc = Location.create(this.toolPath);
        int byteOffset = this.goOpContext.getByteOffsetFromEncoding(this.goOpContext.opContext.getOffset());
        ArrayList2<String> commandLine = new ArrayList2<String>(toolLoc.toPathString(), "-f", this.opContext.getFileLocation().toPathString(), "-i", "-o", Integer.toString(byteOffset));
        this.toolInput = this.opContext.getSource();
        return this.goEnv.createProcessBuilder(commandLine, null, true);
    }

    @Override
    protected void handleNonZeroExitCode(ExternalProcessHelper.ExternalProcessResult result) throws OperationSoftFailure {
        String errOut = result.getStdErrBytes().toString(StringUtil.UTF8);
        if (!errOut.trim().contains("\n")) {
            throw new OperationSoftFailure(errOut);
        }
    }

    @Override
    public SourceLocation parseOutput(StringCharSource output) throws CommonException, OperationSoftFailure {
        int char0 = output.lookahead(0);
        int char1 = output.lookahead(1);
        if (char0 == 45 && (char1 == -1 || char1 == 10)) {
            throw new OperationSoftFailure("Target element is not defined in any source file.");
        }
        return ToolOutputParseHelper.parsePathLineColumn(output.getSource().trim(), ":");
    }
}

