/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.goclipse.tooling.oracle;

import melnorme.utilbox.core.CommonException;
import melnorme.utilbox.misc.NumberUtil;
import org.json.JSONException;
import org.json.JSONObject;

public class JSONParseHelpers {
    public static String readOptionalString(JSONObject jsonObject, String key) throws JSONException, CommonException {
        if (!jsonObject.has(key)) {
            return null;
        }
        return JSONParseHelpers.readString(jsonObject, key);
    }

    public static String readString(JSONObject jsonObject, String key) throws JSONException, CommonException {
        Object stringValue = jsonObject.get(key);
        if (stringValue instanceof String) {
            return (String)stringValue;
        }
        throw new CommonException("Member " + key + " not a String.");
    }

    public static int parsePositiveInt(String optString) throws CommonException {
        int integer = NumberUtil.parseInt(optString);
        if (integer < 0) {
            throw new CommonException("Integer is not positive: " + optString);
        }
        return integer;
    }
}

