/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.tests;

import melnorme.lang.tests.CommonToolingTest;
import melnorme.lang.tooling.parser.lexer.IPredicateLexingRule;
import melnorme.lang.utils.parse.StringCharSource;

public abstract class CommonLexerRuleTest
extends CommonToolingTest {
    public void testRule(String source) {
        this.testRule(source, true);
    }

    public void testRule(String source, boolean terminatedSuccessfuly) {
        this.testRule(source, source.length());
        if (terminatedSuccessfuly) {
            this.testRule(String.valueOf(source) + this.getRuleNeutralSuffix(), source.length());
        }
    }

    protected String getRuleNeutralSuffix() {
        return "xxxx";
    }

    public void testRule(String source, int expectedTokenLength) {
        CommonLexerRuleTest.testRule(this.createLexingRule(), source, expectedTokenLength);
    }

    protected abstract IPredicateLexingRule createLexingRule();

    public static void testRule(IPredicateLexingRule lexRule, String source, int expectedTokenLength) {
        StringCharSource reader = new StringCharSource(source);
        boolean isMatch = lexRule.tryMatch(reader);
        CommonLexerRuleTest.assertEquals(isMatch, expectedTokenLength > 0);
        if (isMatch) {
            CommonLexerRuleTest.assertEquals(reader.getReadPosition(), expectedTokenLength);
        }
    }
}

