/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.tests;

import java.io.File;
import java.nio.file.Path;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.misc.Location;
import melnorme.utilbox.misc.PathUtil;

public class LangToolingTestResources {
    protected static final String TEST_RESOURCES_BASE_DIR_PROPERTY = "TestsResourcesDir";
    protected static final String TESTDATA = "testdata";
    protected static LangToolingTestResources instance;
    private Location testResourcesDir;

    public static synchronized LangToolingTestResources getInstance() {
        if (instance == null) {
            instance = new LangToolingTestResources();
        }
        return instance;
    }

    public LangToolingTestResources() {
        String testResourcesDir = System.getProperty(TEST_RESOURCES_BASE_DIR_PROPERTY);
        if (testResourcesDir == null) {
            testResourcesDir = "../plugin_tooling/testdata";
        }
        Path path = PathUtil.createValidPath(testResourcesDir);
        this.testResourcesDir = Location.create_fromValid(path.toAbsolutePath());
        System.out.println("[==] testResourcesDir: " + testResourcesDir);
    }

    public Location getResourcesDir() {
        Assert.AssertNamespace.assertTrue(this.testResourcesDir != null);
        File file = this.testResourcesDir.toFile();
        Assert.AssertNamespace.assertTrue(file.exists() && file.isDirectory());
        return this.testResourcesDir;
    }

    public static File getTestResourceFile(String ... segments) {
        return LangToolingTestResources.getTestResourceLoc(segments).toFile();
    }

    public static Path getTestResourcePath(String ... segments) {
        return LangToolingTestResources.getTestResourceLoc(segments).toPath();
    }

    public static Location getTestResourceLoc(String ... segments) {
        Location loc = LangToolingTestResources.getInstance().getResourcesDir();
        String[] stringArray = segments;
        int n = segments.length;
        int n2 = 0;
        while (n2 < n) {
            String pathSegment = stringArray[n2];
            loc = loc.resolve_fromValid(pathSegment);
            ++n2;
        }
        Assert.AssertNamespace.assertTrue(loc.toFile().exists());
        return loc;
    }

    public static String resourceFileToString(File file) {
        return LangToolingTestResources.resourceFileToString(file, TESTDATA);
    }

    public static String resourceFileToString(File file, String rootDir) {
        if (file.getName().equals(rootDir)) {
            return "#";
        }
        File parentFile = file.getParentFile();
        String parentStr = parentFile != null ? LangToolingTestResources.resourceFileToString(parentFile, rootDir) : "";
        return String.valueOf(parentStr) + "/" + file.getName();
    }
}

