/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.tooling;

import java.util.Iterator;
import java.util.RandomAccess;
import melnorme.utilbox.collections.ArrayView;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.core.CoreUtil;
import melnorme.utilbox.misc.StringUtil;

public class AbstractElementName2
implements RandomAccess,
Iterable<String> {
    protected final String elementName;
    protected final String separator;
    protected final ArrayView<String> segments;

    public AbstractElementName2(String elementName, String separator) {
        this(elementName, separator, StringUtil.splitString(elementName, separator.charAt(0)));
    }

    public AbstractElementName2(String[] segments, String separator) {
        this(StringUtil.collToString(segments, separator), separator, segments);
    }

    protected AbstractElementName2(String elementName, String separator, String[] segments) {
        this(elementName, separator, ArrayView.create(segments));
    }

    protected AbstractElementName2(String elementName, String separator, ArrayView<String> segments) {
        this.separator = Assert.AssertNamespace.assertNotNull(separator);
        this.elementName = Assert.AssertNamespace.assertNotNull(elementName);
        this.segments = Assert.AssertNamespace.assertNotNull(segments);
        Assert.AssertNamespace.assertTrue(segments.size() > 0);
        for (String segment : segments) {
            Assert.AssertNamespace.assertNotNull(segment);
            Assert.AssertNamespace.assertTrue(!segment.contains(separator));
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AbstractElementName2)) {
            return false;
        }
        AbstractElementName2 other = (AbstractElementName2)obj;
        return CoreUtil.areEqual(this.elementName, other.elementName) && CoreUtil.areEqual(this.separator, other.separator);
    }

    public int hashCode() {
        return this.elementName.hashCode();
    }

    public String getLastSegment() {
        return this.segments.get(this.segments.size() - 1);
    }

    public ArrayView<String> getSegments() {
        return this.segments;
    }

    public String getSegment(int index) {
        return this.segments.get(index);
    }

    public String getFullNameAsString() {
        return this.elementName;
    }

    @Override
    public Iterator<String> iterator() {
        return this.segments.iterator();
    }

    public String toString() {
        return "[" + this.elementName + "]";
    }
}

