/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.tooling.bundle;

import java.nio.file.Path;
import java.text.MessageFormat;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.core.CommonException;
import melnorme.utilbox.core.CoreUtil;
import melnorme.utilbox.misc.HashcodeUtil;
import melnorme.utilbox.misc.PathUtil;
import melnorme.utilbox.misc.StringUtil;

public class FileRef {
    protected final String binaryPath;
    protected final String sourcePath;

    public FileRef(String binaryPath, String sourcePath) {
        this.binaryPath = Assert.AssertNamespace.assertNotNull(binaryPath);
        this.sourcePath = sourcePath;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FileRef)) {
            return false;
        }
        FileRef other = (FileRef)obj;
        return CoreUtil.areEqual(this.binaryPath, other.binaryPath) && CoreUtil.areEqual(this.sourcePath, other.sourcePath);
    }

    public int hashCode() {
        return HashcodeUtil.combinedHashCode(this.binaryPath, this.sourcePath);
    }

    public String toString() {
        return MessageFormat.format("{0}@`{1}`", this.binaryPath, StringUtil.nullAsEmpty(this.sourcePath));
    }

    public String getBinaryPathString() {
        return this.binaryPath;
    }

    public String getSourcePathString() {
        return this.sourcePath;
    }

    public Path getBinaryPath() throws CommonException {
        return FileRef.asPath(this.binaryPath);
    }

    public Path getSourcePath() throws CommonException {
        return FileRef.asPath(this.sourcePath);
    }

    public static Path asPath(String pathString) throws CommonException {
        return pathString == null ? null : PathUtil.createPath(pathString);
    }
}

