/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.tooling.common;

import java.util.Optional;
import melnorme.lang.tooling.ast.SourceRange;
import melnorme.lang.tooling.toolchain.ops.SourceOpContext;
import melnorme.utilbox.concurrency.OperationCancellation;
import melnorme.utilbox.core.CommonException;
import melnorme.utilbox.core.CoreUtil;
import melnorme.utilbox.misc.Location;

public interface ISourceBuffer {
    public Location getLocation_orNull();

    default public Optional<Location> getLocation_opt() {
        return CoreUtil.option(this.getLocation_orNull());
    }

    default public Location getLocation() throws CommonException {
        if (this.getLocation_orNull() == null) {
            throw new CommonException("No file location for this operation");
        }
        return this.getLocation_orNull();
    }

    public String getSource();

    public boolean isDirty();

    default public void trySaveBufferIfDirty() throws CommonException, OperationCancellation {
        if (!this.isDirty()) {
            return;
        }
        this.doTrySaveBuffer();
    }

    public void doTrySaveBuffer() throws CommonException, OperationCancellation;

    public ISourceBuffer getReadOnlyView();

    default public SourceOpContext getSourceOpContext(SourceRange range) {
        return this.getSourceOpContext(range.getOffset(), new SourceRange(range.getOffset(), 0));
    }

    default public SourceOpContext getSourceOpContext(int offset, SourceRange selection) {
        return new SourceOpContext(this.getLocation_opt(), offset, selection, this.getSource(), this.isDirty());
    }
}

