/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.tooling.common;

import java.util.Comparator;
import melnorme.lang.tooling.ast.ParserErrorTypes;
import melnorme.lang.tooling.ast.SourceRange;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.core.CoreUtil;
import melnorme.utilbox.status.Severity;

public class ParserError {
    public final ParserErrorTypes errorType;
    public final Severity severity;
    public final SourceRange sourceRange;
    public final String msgErrorSource;
    public final Object msgData;

    public ParserError(ParserErrorTypes errorType, SourceRange sourceRange, String msgErrorSource, Object msgData) {
        this(errorType, Severity.ERROR, sourceRange, msgErrorSource, msgData);
    }

    public ParserError(ParserErrorTypes errorType, Severity severity, SourceRange sourceRange, String msgErrorSource, Object msgData) {
        this.errorType = Assert.AssertNamespace.assertNotNull(errorType);
        this.severity = Assert.AssertNamespace.assertNotNull(severity);
        this.sourceRange = Assert.AssertNamespace.assertNotNull(sourceRange);
        this.msgErrorSource = msgErrorSource;
        this.msgData = msgData;
    }

    public int getOffset() {
        return this.sourceRange.getOffset();
    }

    public int getLength() {
        return this.sourceRange.getLength();
    }

    public int getStartPos() {
        return this.getOffset();
    }

    public int getEndPos() {
        return this.getOffset() + this.getLength();
    }

    public SourceRange getSourceRange() {
        return this.sourceRange;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ParserError)) {
            return false;
        }
        ParserError other = (ParserError)obj;
        return CoreUtil.areEqual((Object)this.errorType, (Object)other.errorType) && CoreUtil.areEqual(this.sourceRange, other.sourceRange) && CoreUtil.areEqual(this.msgErrorSource, other.msgErrorSource) && CoreUtil.areEqual(this.msgData, other.msgData);
    }

    public String toString() {
        return "ERROR:" + (Object)((Object)this.errorType) + this.sourceRange.toString() + (this.msgErrorSource == null ? "" : "\u3010" + this.msgErrorSource + "\u3011") + "(" + this.msgData + ")";
    }

    public String getUserMessage() {
        return this.errorType.getUserMessage(this);
    }

    public static final class ErrorSourceRangeComparator
    implements Comparator<ParserError> {
        @Override
        public int compare(ParserError o1, ParserError o2) {
            int compareResult = o1.sourceRange.compareTo(o2.sourceRange);
            return compareResult;
        }
    }
}

