/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.tooling.common;

import java.nio.file.Path;
import melnorme.lang.tooling.common.SourceLineColumnRange;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.core.CoreUtil;
import melnorme.utilbox.misc.HashcodeUtil;
import melnorme.utilbox.status.Severity;

public class ToolSourceMessage {
    public final Path path;
    public final SourceLineColumnRange range;
    public final Severity severity;
    public final String message;

    public ToolSourceMessage(Path path, SourceLineColumnRange range, Severity severity, String message) {
        this.path = Assert.AssertNamespace.assertNotNull(path);
        this.range = Assert.AssertNamespace.assertNotNull(range);
        this.message = Assert.AssertNamespace.assertNotNull(message);
        this.severity = Assert.AssertNamespace.assertNotNull(severity);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ToolSourceMessage)) {
            return false;
        }
        ToolSourceMessage other = (ToolSourceMessage)obj;
        return CoreUtil.areEqual(this.path, other.path) && CoreUtil.areEqual(this.range, other.range) && CoreUtil.areEqual((Object)this.severity, (Object)other.severity) && CoreUtil.areEqual(this.message, other.message);
    }

    public int hashCode() {
        return HashcodeUtil.combineHashCodes(HashcodeUtil.getHashCode(this.range), HashcodeUtil.getHashCode(this.message));
    }

    public String toString() {
        return this.range + " " + (Object)((Object)this.severity) + ": " + this.message;
    }

    public Path getFilePath() {
        return this.path;
    }

    public int getFileLineNumber() {
        return this.range.line;
    }

    public int getFileColumnNumber() {
        return this.range.column;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public String getMessage() {
        return this.message;
    }
}

