/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.tooling.completion;

import java.text.MessageFormat;
import melnorme.lang.tooling.CompletionProposalKind;
import melnorme.lang.tooling.ElementAttributes;
import melnorme.lang.tooling.ast.SourceRange;
import melnorme.utilbox.collections.Indexable;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.core.CoreUtil;
import melnorme.utilbox.misc.CollectionUtil;
import melnorme.utilbox.misc.HashcodeUtil;

public abstract class LangToolCompletionProposal {
    protected final int replaceOffset;
    protected final int replaceLength;
    protected final String baseReplaceString;
    protected final String label;
    protected final CompletionProposalKind kind;
    protected final ElementAttributes attributes;
    protected final String typeLabel;
    protected final String moduleName;
    protected final String documentation;
    protected final String fullReplaceString;
    protected final Indexable<SourceRange> sourceSubElements;

    public LangToolCompletionProposal(int replaceOffset, int replaceLength, String baseReplaceString, String label, CompletionProposalKind kind, ElementAttributes attributes, String typeLabel, String moduleName, String documentation, String fullReplaceString, Indexable<SourceRange> sourceSubElements) {
        Assert.AssertNamespace.assertTrue(replaceOffset >= 0);
        Assert.AssertNamespace.assertTrue(replaceLength >= 0);
        this.replaceOffset = replaceOffset;
        this.replaceLength = replaceLength;
        this.baseReplaceString = Assert.AssertNamespace.assertNotNull(baseReplaceString);
        this.label = Assert.AssertNamespace.assertNotNull(label);
        this.kind = kind != null ? kind : CompletionProposalKind.UNKNOWN;
        this.attributes = Assert.AssertNamespace.assertNotNull(attributes);
        this.typeLabel = typeLabel;
        this.moduleName = moduleName;
        this.documentation = documentation;
        this.fullReplaceString = Assert.AssertNamespace.assertNotNull(fullReplaceString);
        this.sourceSubElements = CollectionUtil.nullToEmpty(sourceSubElements);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LangToolCompletionProposal)) {
            return false;
        }
        LangToolCompletionProposal other = (LangToolCompletionProposal)obj;
        return CoreUtil.areEqual(this.replaceOffset, other.replaceOffset) && CoreUtil.areEqual(this.replaceLength, other.replaceLength) && CoreUtil.areEqual(this.baseReplaceString, other.baseReplaceString) && CoreUtil.areEqual(this.label, other.label) && CoreUtil.areEqual((Object)this.kind, (Object)other.kind) && CoreUtil.areEqual(this.attributes, other.attributes) && CoreUtil.areEqual(this.typeLabel, other.typeLabel) && CoreUtil.areEqual(this.moduleName, other.moduleName) && CoreUtil.areEqual(this.documentation, other.documentation) && CoreUtil.areEqual(this.fullReplaceString, other.fullReplaceString) && CoreUtil.areEqual(this.sourceSubElements, other.sourceSubElements) && this.subclassEquals(other);
    }

    protected abstract boolean subclassEquals(LangToolCompletionProposal var1);

    public int hashCode() {
        return HashcodeUtil.combinedHashCode(new Object[]{this.replaceOffset, this.replaceLength, this.baseReplaceString, this.label, this.kind, this.moduleName});
    }

    public int getReplaceOffset() {
        return this.replaceOffset;
    }

    public int getReplaceLength() {
        return this.replaceLength;
    }

    public String getBaseReplaceString() {
        return this.baseReplaceString;
    }

    public String getLabel() {
        return Assert.AssertNamespace.assertNotNull(this.label);
    }

    public CompletionProposalKind getKind() {
        return Assert.AssertNamespace.assertNotNull(this.kind);
    }

    public ElementAttributes getAttributes() {
        return this.attributes;
    }

    public String getTypeLabel() {
        return this.typeLabel;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public String getFullReplaceString() {
        return this.fullReplaceString;
    }

    public Indexable<SourceRange> getSourceSubElements() {
        return this.sourceSubElements;
    }

    public String toString() {
        return MessageFormat.format("PROPOSAL: @{0}+{1} {2} [{3}] {4} {5} {6}", new Object[]{this.getReplaceOffset(), this.getReplaceLength(), this.getLabel(), this.getKind(), this.getAttributes(), this.getTypeLabel(), this.moduleName == null ? "" : " - " + this.moduleName});
    }
}

