/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.tooling.parser;

import melnorme.lang.tooling.parser.SourceLinesInfo;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.core.CommonException;
import melnorme.utilbox.tests.CommonTest;
import org.junit.Test;

public class SourceLinesInfo_Test
extends CommonTest {
    @Test
    public void test() throws Exception {
        this.test$();
    }

    public void test$() throws Exception {
        this.getSourceLinesInfo("");
        this.getSourceLinesInfo("\n");
        SourceLinesInfo sourceLinesInfo = this.getSourceLinesInfo("12345\n12345");
        this.testOffset(sourceLinesInfo, 1, 0, 0, 1);
        this.testOffset(sourceLinesInfo, 5, 0, 0, 5);
        this.testOffset(sourceLinesInfo, 6, 1, 6, 0);
        this.testOffset(sourceLinesInfo, 7, 1, 6, 1);
        SourceLinesInfo_Test.verifyThrows(() -> {
            int n = sourceLinesInfo.getValidatedOffset_1(1, 10);
        }, null, "Invalid column, out of bounds");
        SourceLinesInfo_Test.verifyThrows(() -> {
            int n = sourceLinesInfo.getValidatedOffset_1(2, 10);
        }, null, "line+column, out of bounds");
        SourceLinesInfo_Test.verifyThrows(() -> {
            int n = sourceLinesInfo.getValidatedOffset_1(3, 1);
        }, null, "Invalid line: 3 is over the max bound: 2");
        SourceLinesInfo_Test.assertEquals(sourceLinesInfo.getValidatedOffset_1(1, 1), 0);
        SourceLinesInfo_Test.assertEquals(sourceLinesInfo.getValidatedOffset_1(2, 1), 6);
        SourceLinesInfo_Test.assertEquals(sourceLinesInfo.getValidatedOffset_1(2, 6), "12345\n12345".length());
    }

    public SourceLinesInfo getSourceLinesInfo(String sampleSource) throws CommonException {
        SourceLinesInfo sourceLinesInfo = new SourceLinesInfo(sampleSource);
        this.testOffset(sourceLinesInfo, 0, 0, 0, 0);
        SourceLinesInfo_Test.assertEquals(sourceLinesInfo.getLineForOffset(sampleSource.length()), sourceLinesInfo.getNumberOfLines() - 1);
        int lengthPlusOne = sampleSource.length() + 1;
        SourceLinesInfo_Test.verifyThrows(() -> {
            int n2 = sourceLinesInfo.getLineForOffset(lengthPlusOne);
        }, null, "Invalid offset " + lengthPlusOne + ", it is out of bounds.");
        return sourceLinesInfo;
    }

    protected void testOffset(SourceLinesInfo sourceLinesInfo, int offset, int expectedLine, int expectedLineStart, int expectedColumn) {
        try {
            SourceLinesInfo_Test.assertEquals(sourceLinesInfo.getLineForOffset(offset), expectedLine);
            SourceLinesInfo_Test.assertEquals(sourceLinesInfo.getLineStartForOffset(offset), expectedLineStart);
            SourceLinesInfo_Test.assertEquals(sourceLinesInfo.getColumnForOffset(offset), expectedColumn);
        }
        catch (CommonException e) {
            Assert.AssertNamespace.assertFail();
        }
    }
}

