/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.tooling.parser.lexer;

import melnorme.lang.tooling.parser.lexer.IPredicateLexingRule;
import melnorme.lang.utils.parse.ICharacterReader;
import melnorme.utilbox.misc.NumberUtil;

public abstract class NumberLexingRule
implements IPredicateLexingRule {
    @Override
    public boolean doEvaluate(ICharacterReader reader) {
        int radix = 10;
        if (reader.tryConsume('0')) {
            if (reader.tryConsume('b')) {
                radix = 2;
            } else if (reader.tryConsume('o')) {
                radix = 8;
            } else if (reader.tryConsume('x')) {
                radix = 16;
            }
        } else if (!NumberLexingRule.consumeDigit(reader, radix)) {
            return false;
        }
        this.consumeDigits(reader, radix, true);
        if (this.consumeIntSuffix(reader)) {
            return true;
        }
        this.tryConsumeFractionalPart(reader, radix);
        return true;
    }

    protected boolean consumeDigits(ICharacterReader reader, int radix, boolean allowUnderScore) {
        boolean consumedAny = false;
        while (NumberLexingRule.consumeDigit(reader, radix) || allowUnderScore && reader.tryConsume('_')) {
            consumedAny = true;
        }
        return consumedAny;
    }

    protected abstract boolean consumeIntSuffix(ICharacterReader var1);

    protected void tryConsumeFractionalPart(ICharacterReader reader, int radix) {
        boolean hasPrefix;
        boolean bl = hasPrefix = radix != 10;
        if (!hasPrefix) {
            this.consumeFractionalPart(reader, radix);
        }
    }

    protected void consumeFractionalPart(ICharacterReader reader, int radix) {
        if (reader.lookahead() != 46 || !this.isAllowedAfterFractionDot(reader.lookahead(1))) {
            return;
        }
        reader.consume();
        boolean hasFractionalDigits = this.tryConsumeFractionalPartDigits(reader, radix);
        if (hasFractionalDigits && (reader.tryConsume('e') || reader.tryConsume('E'))) {
            if (!reader.tryConsume('+')) {
                reader.tryConsume('-');
            }
            this.consumeDigits(reader, 10, true);
        }
        this.consumeFloatSuffix(reader);
    }

    protected boolean isAllowedAfterFractionDot(int afterDot) {
        return afterDot == -1 || afterDot != 46 && afterDot != 95 && !Character.isLetter(afterDot);
    }

    protected boolean tryConsumeFractionalPartDigits(ICharacterReader reader, int radix) {
        if (NumberLexingRule.consumeDigit(reader, radix)) {
            this.consumeDigits(reader, radix, true);
            return true;
        }
        return false;
    }

    protected static boolean consumeDigit(ICharacterReader reader, int radix) {
        if (reader.hasCharAhead() && NumberUtil.isDigit(reader.lookaheadChar(), radix)) {
            reader.consume();
            return true;
        }
        return false;
    }

    protected abstract boolean consumeFloatSuffix(ICharacterReader var1);
}

