/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.tooling.structure;

import melnorme.lang.tooling.structure.IStructureElementContainer;
import melnorme.lang.tooling.structure.StructureElement;
import melnorme.utilbox.collections.Indexable;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.core.CoreUtil;
import melnorme.utilbox.misc.HashcodeUtil;

public abstract class AbstractStructureContainer
implements IStructureElementContainer {
    protected final Indexable<StructureElement> children;

    public AbstractStructureContainer(Indexable<? extends StructureElement> _children) {
        this.children = CoreUtil.nullToEmpty(_children).upcastTypeParameter();
        for (StructureElement child : this.children) {
            child.setParent(this);
        }
        this._invariant();
    }

    protected void _invariant() {
        for (StructureElement element : this.getChildren()) {
            Assert.AssertNamespace.assertTrue(element.getParent() == this);
        }
    }

    @Override
    public Indexable<StructureElement> getChildren() {
        return this.children;
    }

    public static class SimpleStructureContainer
    extends AbstractStructureContainer {
        public SimpleStructureContainer(Indexable<? extends StructureElement> children) {
            super(children);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof SimpleStructureContainer)) {
                return false;
            }
            SimpleStructureContainer other = (SimpleStructureContainer)obj;
            return CoreUtil.areEqual(this.children, other.children);
        }

        public int hashCode() {
            return HashcodeUtil.combinedHashCode(this.children);
        }
    }
}

