/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.tooling.structure;

import melnorme.lang.tests.CommonToolingTest;
import melnorme.lang.tooling.EAttributeFlag;
import melnorme.lang.tooling.EProtection;
import melnorme.lang.tooling.ElementAttributes;
import melnorme.lang.tooling.ast.SourceRange;
import melnorme.lang.tooling.common.ParserError;
import melnorme.lang.tooling.structure.AbstractStructureParser;
import melnorme.lang.tooling.structure.SourceFileStructure;
import melnorme.lang.tooling.structure.StructureElement;
import melnorme.lang.tooling.structure.StructureElementKind;
import melnorme.utilbox.collections.ArrayList2;
import melnorme.utilbox.collections.Indexable;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.core.CommonException;
import melnorme.utilbox.misc.StringUtil;

public abstract class AbstractStructureParser_Test
extends CommonToolingTest {
    protected static final String DEFAULT_SOURCE = "aaaaa\n0123456789\nxxx\nabcdefghijkl\n";
    protected String source = "aaaaa\n0123456789\nxxx\nabcdefghijkl\n";

    public static String quoteString(String string) {
        return String.valueOf('\"') + StringUtil.replaceAll(string, "\"", "\\\"") + '\"';
    }

    protected SourceRange sr(int offset, int length) {
        return new SourceRange(offset, length);
    }

    protected SourceRange srAt(int startPos, int endPos) {
        return SourceRange.srStartToEnd(startPos, endPos);
    }

    protected int pos(int line_0, int col_0) {
        int lineOffset = 0;
        while (line_0 > 0) {
            int newIx = this.source.indexOf(10, lineOffset);
            Assert.AssertNamespace.assertTrue(newIx > 0);
            lineOffset = newIx + 1;
            --line_0;
        }
        return lineOffset + col_0;
    }

    public static ElementAttributes attrib(EProtection protection, EAttributeFlag ... flags) {
        return new ElementAttributes(protection, flags);
    }

    public static ElementAttributes att(EAttributeFlag ... flags) {
        return new ElementAttributes(EProtection.PUBLIC, flags);
    }

    public static ElementAttributes attPriv(EAttributeFlag ... flags) {
        return new ElementAttributes(EProtection.PRIVATE, flags);
    }

    public StructureElement elem(String name, SourceRange sr, SourceRange nameSR, StructureElementKind elementKind, ElementAttributes elementAttributes, String type, Indexable<StructureElement> children) {
        if (elementAttributes == null) {
            elementAttributes = new ElementAttributes(null, new EAttributeFlag[0]);
        }
        return new StructureElement(name, nameSR, sr, elementKind, elementAttributes, type, children);
    }

    protected void testParseStructure(String describeOutput, Indexable<ParserError> parserProblems, StructureElement ... expectedElements) throws CommonException {
        ArrayList2<StructureElement> expectedStructure = new ArrayList2<StructureElement>(expectedElements);
        SourceFileStructure expected = new SourceFileStructure(null, expectedStructure, parserProblems);
        this.testParseStructure(describeOutput, expected);
    }

    protected void testParseStructure(String describeOutput, SourceFileStructure expected) throws CommonException {
        AbstractStructureParser parser = this.createStructureParser();
        SourceFileStructure structure = parser.parse(describeOutput);
        AbstractStructureParser_Test.assertAreEqual(structure.getChildren(), expected.getChildren());
        AbstractStructureParser_Test.assertEquals(expected, structure);
    }

    protected abstract AbstractStructureParser createStructureParser();
}

