/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.tooling.toolchain.ops;

import java.text.MessageFormat;
import melnorme.lang.utils.validators.LocationValidator;
import melnorme.utilbox.fields.validation.ValidationException;
import melnorme.utilbox.misc.Location;
import melnorme.utilbox.misc.MiscUtil;
import melnorme.utilbox.status.Severity;

public abstract class SDKLocationValidator
extends LocationValidator {
    public SDKLocationValidator(String fieldNamePrefix) {
        super(fieldNamePrefix);
        this.directoryOnly = true;
    }

    @Override
    protected Location getValidatedField_rest(Location sdkLocation) throws ValidationException {
        Location sdkExecutableLocation = this.getSDKExecutableLocation(sdkLocation);
        if (!sdkExecutableLocation.toFile().exists()) {
            throw this.createException(Severity.WARNING, this.getSDKExecutableErrorMessage(sdkExecutableLocation));
        }
        return sdkExecutableLocation;
    }

    protected Location getSDKExecutableLocation(Location location) {
        String exeRelativePath = this.getSDKExecutable_append();
        if (MiscUtil.OS_IS_WINDOWS) {
            exeRelativePath = String.valueOf(exeRelativePath) + ".exe";
        }
        return location.resolve_fromValid(exeRelativePath);
    }

    protected abstract String getSDKExecutable_append();

    protected String getSDKExecutableErrorMessage(Location exeLocation) {
        return MessageFormat.format("`{0}` executable not found.", exeLocation);
    }
}

