/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.tooling.toolchain.ops;

import java.nio.file.Path;
import melnorme.lang.tooling.common.LineColumnPosition;
import melnorme.lang.tooling.common.SourceLineColumnRange;
import melnorme.lang.tooling.toolchain.ops.SourceLocation;
import melnorme.utilbox.core.CommonException;
import melnorme.utilbox.misc.Location;
import melnorme.utilbox.misc.MiscUtil;
import melnorme.utilbox.misc.NumberUtil;
import melnorme.utilbox.misc.Pair;
import melnorme.utilbox.misc.StringUtil;

public interface ToolOutputParseHelper {
    default public int parsePositiveInt(String integerString) throws CommonException {
        return NumberUtil.parsePositiveInt(integerString);
    }

    default public int parseInt(String integerString) throws CommonException {
        return NumberUtil.parseInt(integerString);
    }

    default public int parseInt(String integerString, String errorMessage) throws CommonException {
        return NumberUtil.parseInt(integerString, errorMessage);
    }

    default public Path parsePath(String pathString) throws CommonException {
        return MiscUtil.createPath(pathString);
    }

    default public Location parseLocation(String pathString) throws CommonException {
        return Location.create(pathString);
    }

    public static SourceLocation parsePathLineColumn(String sourceString, String separator) throws CommonException {
        Pair<String, LineColumnPosition> pair = ToolOutputParseHelper.parsePathLineColumn2(sourceString, separator);
        Location loc = Location.create(pair.getFirst());
        LineColumnPosition lcPos = pair.getSecond();
        return new SourceLocation(loc, new SourceLineColumnRange(lcPos.line, lcPos.column));
    }

    public static Pair<String, LineColumnPosition> parsePathLineColumn2(String sourceString, String separator) throws CommonException {
        String columnStr = StringUtil.segmentAfterLastMatch(sourceString, separator);
        sourceString = StringUtil.substringUntilLastMatch(sourceString, separator);
        String lineStr = StringUtil.segmentAfterLastMatch(sourceString, separator);
        String pathString = sourceString = StringUtil.substringUntilLastMatch(sourceString, separator);
        LineColumnPosition second = ToolOutputParseHelper.parseLineColumn(lineStr, columnStr, 0, 0);
        return Pair.create(pathString, second);
    }

    public static LineColumnPosition parseLineColumn(String lineStr, String columnStr, int line_start, int column_start) throws CommonException {
        if (columnStr == null || lineStr == null) {
            throw new CommonException("No line or column position given.", null);
        }
        int line = NumberUtil.parseInt(lineStr, "Line is not a number: " + lineStr);
        if (line < line_start) {
            throw new CommonException("Line is not a positive number: " + lineStr);
        }
        int column = NumberUtil.parseInt(columnStr, "Column is not a number: " + columnStr);
        if (column < column_start) {
            throw new CommonException("Column is not a positive number: " + columnStr);
        }
        return new LineColumnPosition(line, column);
    }
}

