/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.utils;

import java.io.File;
import java.nio.file.Path;
import java.util.Map;
import melnorme.utilbox.core.CommonException;
import melnorme.utilbox.misc.Location;
import melnorme.utilbox.misc.MiscUtil;
import melnorme.utilbox.misc.StringUtil;

public class EnvUtils {
    public static void addCmdDirToPathEnv(Path cmdExePath, ProcessBuilder pb) {
        Location cmdLoc = Location.createValidOrNull(cmdExePath);
        if (cmdLoc == null) {
            return;
        }
        if ((cmdLoc = cmdLoc.getParent()) == null) {
            return;
        }
        EnvUtils.addLocationToPathEnv(cmdLoc, pb);
    }

    public static void addLocationToPathEnv(Location dirLoc, ProcessBuilder pb) {
        Map<String, String> environment = pb.environment();
        String pathEnv = EnvUtils.getVarFromEnvMap(environment, "PATH");
        String newPathEnv = String.valueOf(dirLoc.toString()) + File.pathSeparator + StringUtil.nullAsEmpty(pathEnv);
        EnvUtils.putVarInEnvMap(environment, "PATH", newPathEnv);
    }

    public static String getVarFromEnvMap(Map<String, String> envMap, String key) {
        key = EnvUtils.getCorrectEnvKey(envMap, key);
        return envMap.get(key);
    }

    public static void putVarInEnvMap(Map<String, String> envMap, String key, String value) {
        key = EnvUtils.getCorrectEnvKey(envMap, key);
        envMap.put(key, value);
    }

    public static String getCorrectEnvKey(Map<String, String> envMap, String key) {
        boolean containsKey = envMap.containsKey(key);
        if (!containsKey && MiscUtil.OS_IS_WINDOWS) {
            for (String otherKey : envMap.keySet()) {
                if (!otherKey.equalsIgnoreCase(key)) continue;
                return otherKey;
            }
        }
        return key;
    }

    public static Location getLocationFromEnvVar(String envVar) throws CommonException {
        String home = EnvUtils.getVarFromEnvMap(System.getenv(), envVar);
        if (home == null) {
            throw new CommonException(String.valueOf(envVar) + " environment variable not set.");
        }
        try {
            return Location.create(home);
        }
        catch (CommonException ce) {
            throw new CommonException("Error with " + envVar + " environment variable: " + ce.getMessage(), ce);
        }
    }
}

