/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.utils;

import java.io.IOException;
import java.nio.file.attribute.FileTime;
import melnorme.lang.utils.FileModificationDetectionHelper;
import melnorme.utilbox.misc.Location;

public abstract class FileCachingEntry<VALUE>
extends FileModificationDetectionHelper {
    private VALUE value;

    public FileCachingEntry(Location location) {
        super(location);
    }

    public Location getFileLocation() {
        return this.fileLocation;
    }

    public synchronized VALUE getValue() {
        return this.value;
    }

    public synchronized FileTime getValueTimeStamp() {
        return this.fileSyncAttributes == null ? FileTime.fromMillis(0L) : this.fileSyncAttributes.lastModifiedTime();
    }

    @Override
    public synchronized void markStale() {
        super.markStale();
    }

    public synchronized boolean isStale() {
        return super.isModifiedSinceLastRead();
    }

    public synchronized void updateValue(VALUE value) {
        try {
            this.markRead();
        }
        catch (IOException e) {
            this.markStale();
        }
        this.value = value;
    }

    @Override
    protected abstract void handleWarning_ModifiedTimeInTheFuture(FileTime var1);
}

