/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.utils;

import java.nio.file.Path;
import melnorme.lang.tooling.ToolingMessages;
import melnorme.lang.utils.EnvUtils;
import melnorme.utilbox.collections.ArrayList2;
import melnorme.utilbox.collections.Indexable;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.core.CommonException;
import melnorme.utilbox.misc.Location;

public class ProcessUtils {
    public static ProcessBuilder createProcessBuilder(Indexable<String> commandLine, Location workingDir) {
        Assert.AssertNamespace.assertTrue(commandLine.size() > 0);
        ProcessBuilder pb = new ProcessBuilder(commandLine.toArrayList());
        if (workingDir != null) {
            pb.directory(workingDir.toFile());
        }
        return pb;
    }

    public static ProcessBuilder createProcessBuilder(Path cmdExePath, Location workingDir, String ... arguments) {
        ArrayList2<String> commandLine = ProcessUtils.createCommandLine(cmdExePath, arguments);
        return ProcessUtils.createProcessBuilder(commandLine, workingDir);
    }

    public static ArrayList2<String> createCommandLine(Path cmdExePath, String ... arguments) {
        ArrayList2<String> commandLine = new ArrayList2<String>();
        commandLine.add(cmdExePath.toString());
        commandLine.addElements(arguments);
        return commandLine;
    }

    public static ProcessBuilder createProcessBuilder(Path cmdExePath, Location workingDir, boolean addCmdDirToPath, String ... arguments) {
        ProcessBuilder pb = ProcessUtils.createProcessBuilder(cmdExePath, workingDir, arguments);
        if (addCmdDirToPath) {
            EnvUtils.addCmdDirToPathEnv(cmdExePath, pb);
        }
        return pb;
    }

    public static void validateNonZeroExitValue(int exitValue) throws CommonException {
        ProcessUtils.validateNonZeroExitValue("Process", exitValue);
    }

    public static void validateNonZeroExitValue(String processName, int exitValue) throws CommonException {
        if (exitValue != 0) {
            throw new CommonException(ToolingMessages.PROCESS_CompletedWithNonZeroValue(processName, exitValue));
        }
    }
}

