/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.utils;

import java.io.File;
import java.nio.file.Path;
import melnorme.utilbox.core.CommonException;
import melnorme.utilbox.misc.Location;
import melnorme.utilbox.misc.MiscUtil;

public abstract class SearchPathEnvOperation {
    public void searchEnvironmentVar(String envVarName) {
        String fullPathString = System.getenv(envVarName);
        if (fullPathString != null) {
            this.searchPathsString(fullPathString, envVarName);
        }
    }

    public void searchPathsString(String pathsString, String envVarName) {
        String separator = SearchPathEnvOperation.getPathsSeparator();
        String[] paths = pathsString.split(separator);
        this.searchPaths(paths, envVarName);
    }

    public static String getPathsSeparator() {
        return File.pathSeparator;
    }

    protected void searchPaths(String[] paths, String envVarName) {
        String[] stringArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            String pathString = stringArray[n2];
            Path path = MiscUtil.createPathOrNull(pathString);
            if (path == null) {
                this.handleWarning("Invalid path: " + pathString + " in env variable: " + envVarName);
            } else if (path.toFile().isDirectory()) {
                try {
                    Location location = Location.create(path);
                    this.searchPathEntry(location);
                }
                catch (CommonException commonException) {
                    // empty catch block
                }
            }
            ++n2;
        }
    }

    protected abstract void handleWarning(String var1);

    protected abstract void searchPathEntry(Location var1);
}

