/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.utils.parse;

import melnorme.lang.utils.parse.IBasicCharSource;
import melnorme.utilbox.core.Assert;

public interface ICharSource<EXC extends Exception>
extends IBasicCharSource<EXC> {
    @Override
    default public int lookahead() throws EXC {
        return this.lookahead(0);
    }

    public int lookahead(int var1) throws EXC;

    public int bufferedCharCount();

    public String lookaheadString(int var1, int var2) throws EXC;

    default public void consume(int amount) throws EXC {
        while (amount-- > 0) {
            this.consume();
        }
    }

    default public boolean tryConsume(String string) throws EXC {
        int ix = 0;
        while (ix < string.length()) {
            if (this.lookahead(ix) != string.charAt(ix)) {
                return false;
            }
            ++ix;
        }
        this.consume(string.length());
        return true;
    }

    default public String consumeString(int length) throws EXC {
        String string = this.lookaheadString(0, length);
        this.consume(length);
        return string;
    }

    default public void consumeAhead(String string) throws EXC {
        Assert.AssertNamespace.assertNotNull(string);
        Assert.AssertNamespace.assertTrue(this.lookaheadMatches(string));
        this.consume(string.length());
    }

    default public boolean lookaheadMatches(String string) throws EXC {
        return this.lookaheadMatches(string, 0);
    }

    default public boolean lookaheadMatches(String string, int fromIndex) throws EXC {
        int ix = 0;
        while (ix < string.length()) {
            if (this.lookahead(ix + fromIndex) != string.charAt(ix)) {
                return false;
            }
            ++ix;
        }
        return true;
    }

    default public String stringUntil(String string) throws EXC {
        int charAtIx;
        int length = 0;
        while ((charAtIx = this.lookahead(length)) != -1 && !this.lookaheadMatches(string, length)) {
            ++length;
        }
        return this.lookaheadString(0, length);
    }

    default public String consumeUntil(String string) throws EXC {
        String stringUntil = this.stringUntil(string);
        this.consume(stringUntil.length());
        return stringUntil;
    }

    default public String consumeUntil(String endString, boolean consumeEndString) throws EXC {
        String firstString = this.consumeUntil(endString);
        if (consumeEndString) {
            this.tryConsume(endString);
        }
        return firstString;
    }
}

