/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.utils.parse;

import melnorme.lang.tests.CommonToolingTest;
import melnorme.lang.tooling.parser.lexer.CharacterReader_SubReader;
import melnorme.lang.utils.parse.ICharSource;
import melnorme.lang.utils.parse.ICharacterReader;
import melnorme.lang.utils.parse.LexingUtils;
import melnorme.lang.utils.parse.StringCharSource;
import melnorme.utilbox.core.Assert;
import org.junit.Test;

public abstract class ParseSource_Test
extends CommonToolingTest {
    protected final String TEST_SOURCE = "abcdef";
    protected ICharacterReader parseSource;
    protected String source;
    protected int sourceIx;
    protected int lookahead;

    protected void init(String source) {
        this.source = source;
        this.parseSource = this.createParseSource(source);
        this.sourceIx = 0;
    }

    protected abstract ICharacterReader createParseSource(String var1);

    @Test
    public void test() throws Exception {
        this.test$();
    }

    public void test$() throws Exception {
        this.doTest______();
    }

    protected void doTest______() throws Exception {
        this.init("abcdef");
        this.testLookahead(97);
        Assert.AssertNamespace.assertTrue(this.parseSource.lookaheadMatches("abc", 0));
        Assert.AssertNamespace.assertTrue(!this.parseSource.lookaheadMatches("bc", 0));
        Assert.AssertNamespace.assertTrue(this.parseSource.lookaheadMatches("bc", 1));
        Assert.AssertNamespace.assertTrue(!this.parseSource.lookaheadMatches("abc", "abcdef".length()));
        Assert.AssertNamespace.assertTrue(this.parseSource.lookaheadMatches("", "abcdef".length()));
        Assert.AssertNamespace.assertTrue(this.parseSource.lookaheadString(0, 6).equals("abcdef"));
        this.parseSource.consume(2);
        Assert.AssertNamespace.assertTrue(this.parseSource.lookaheadString(0, 4).equals("cdef"));
        this.init("abcdef");
        this.testCharSource();
        this.init("abcdef");
        Assert.AssertNamespace.assertTrue(this.parseSource.tryConsume("abc"));
        Assert.AssertNamespace.assertTrue(this.parseSource.lookaheadMatches("def"));
        this.init("abcdef");
        Assert.AssertNamespace.assertTrue(this.parseSource.stringUntil("z").equals("abcdef"));
        Assert.AssertNamespace.assertTrue(this.parseSource.stringUntil("a").equals(""));
        Assert.AssertNamespace.assertTrue(this.parseSource.stringUntil("def").equals("abc"));
        this.parseSource.consumeAhead("abc");
        Assert.AssertNamespace.assertTrue(this.parseSource.stringUntil("def").equals(""));
        Assert.AssertNamespace.assertTrue(this.parseSource.stringUntil("z").equals("def"));
        this.init("abcdef");
        Assert.AssertNamespace.assertTrue(this.parseSource.consumeUntil("def").equals("abc"));
        Assert.AssertNamespace.assertTrue(this.parseSource.lookaheadMatches("def"));
        this.init("abcdef");
        Assert.AssertNamespace.assertTrue(this.parseSource.consumeUntil("de", true).equals("abc"));
        Assert.AssertNamespace.assertTrue(this.parseSource.lookahead() == 102);
        Assert.AssertNamespace.assertTrue(this.parseSource.lookaheadMatches("f"));
    }

    protected void testCharSource() throws Exception {
        this.checkBufferedCount(this.parseSource, 0);
        this.lookahead = this.testLookahead(this.source.charAt(this.sourceIx));
        Assert.AssertNamespace.assertTrue(this.parseSource.lookahead(1) == this.source.charAt(this.sourceIx + 1));
        this.checkBufferedCount(this.parseSource, 2);
        Assert.AssertNamespace.assertTrue(this.parseSource.consume() == this.lookahead);
        ++this.sourceIx;
        this.checkBufferedCount(this.parseSource, 1);
        Assert.AssertNamespace.assertTrue(this.parseSource.consume() == this.source.charAt(this.sourceIx));
        ++this.sourceIx;
        this.checkBufferedCount(this.parseSource, 0);
        this.checkBufferedCount(this.parseSource, 0);
        this.lookahead = this.testLookahead(this.source.charAt(this.sourceIx));
        this.checkBufferedCount(this.parseSource, 1);
        Assert.AssertNamespace.assertTrue(this.lookahead == this.parseSource.consume());
        ++this.sourceIx;
        Assert.AssertNamespace.assertTrue(this.lookahead == 99);
        this.checkBufferedCount(this.parseSource, 0);
        Assert.AssertNamespace.assertTrue(this.parseSource.consume() == this.source.charAt(this.sourceIx));
        ++this.sourceIx;
        while (this.sourceIx < this.source.length()) {
            int ch = this.testLookahead(this.source.charAt(this.sourceIx));
            Assert.AssertNamespace.assertTrue(this.parseSource.consume() == ch);
            ++this.sourceIx;
        }
        this.testLookahead(-1);
        ParseSource_Test.verifyThrows(() -> {
            char c = this.parseSource.consume();
        }, Assert.AssertFailedException.class);
    }

    protected void checkBufferedCount(ICharSource<?> parseSource, int expected) {
        Assert.AssertNamespace.assertTrue(parseSource.bufferedCharCount() == expected);
    }

    protected int testLookahead(int expected) throws Exception {
        return ParseSource_Test.testLookAhead(this.parseSource, expected);
    }

    public static int testLookAhead(ICharSource<?> parseSource, int expected) throws Exception {
        int lookahead = parseSource.lookahead();
        Assert.AssertNamespace.assertTrue(lookahead == expected);
        Assert.AssertNamespace.assertTrue(lookahead == parseSource.lookahead(0));
        return lookahead;
    }

    @Test
    public void test_consumeDelimited() throws Exception {
        this.test_consumeDelimited$();
    }

    public void test_consumeDelimited$() throws Exception {
        this.init("blah");
        this.testConsumeDelimitedString(this.parseSource, '|', '#', "blah");
        this.init("one|two|three##|four#|xxx|###|five");
        this.testConsumeDelimitedString(this.parseSource, '|', '#', "one");
        this.testConsumeDelimitedString(this.parseSource, '|', '#', "two");
        this.testConsumeDelimitedString(this.parseSource, '|', '#', "three#");
        this.testConsumeDelimitedString(this.parseSource, '|', '#', "four|xxx");
        this.testConsumeDelimitedString(this.parseSource, '|', '#', "#|five");
    }

    protected void testConsumeDelimitedString(ICharacterReader parseSource, char delimiter, char escapeChar, String expected) throws Exception {
        CharacterReader_SubReader subReader = new CharacterReader_SubReader(parseSource);
        CharacterReader_SubReader subReaderAlt2 = new CharacterReader_SubReader(parseSource);
        ParseSource_Test.assertEquals(LexingUtils.consumeUntilDelimiterOrEOS(subReader, delimiter, escapeChar), expected);
        LexingUtils.advanceDelimitedString(subReaderAlt2, delimiter, escapeChar);
        Assert.AssertNamespace.assertTrue(subReader.readPosition == subReaderAlt2.readPosition);
        ParseSource_Test.assertEquals(LexingUtils.consumeUntilDelimiterOrEOS(parseSource, delimiter, escapeChar), expected);
    }

    @Test
    public void testConsumeNewline() throws Exception {
        this.testConsumeNewline$();
    }

    public void testConsumeNewline$() throws Exception {
        this.init("abc\ndef\r\nzzz");
        ParseSource_Test.assertAreEqual(LexingUtils.stringUntilNewline(this.parseSource, 0), "abc");
        ParseSource_Test.assertAreEqual(LexingUtils.stringUntilNewline(this.parseSource, 1), "bc");
        ParseSource_Test.assertAreEqual(LexingUtils.stringUntilNewline(this.parseSource, 3), "");
        ParseSource_Test.assertAreEqual(LexingUtils.consumeLine(this.parseSource), "abc");
        ParseSource_Test.assertAreEqual(LexingUtils.consumeLine(this.parseSource), "def");
        ParseSource_Test.assertAreEqual(LexingUtils.consumeLine(this.parseSource), "zzz");
        ParseSource_Test.assertAreEqual(LexingUtils.consumeLine(this.parseSource), null);
    }

    public static class StringParseSource_Test
    extends ParseSource_Test {
        @Override
        protected ICharacterReader createParseSource(String source) {
            return new StringCharSource(source);
        }

        @Override
        protected void checkBufferedCount(ICharSource<?> parseSource, int expected) {
            Assert.AssertNamespace.assertTrue(parseSource.bufferedCharCount() == this.source.length() - this.sourceIx);
        }
    }
}

